Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		maradns
Version:	3.5.0036
Release:	alt1_4
Summary:	Authoritative and recursive DNS server made with security in mind

Source0:	http://www.maradns.org/download/3.5/%{version}/%{name}-%{version}.tar.xz
# http://maradns.samiam.org/download/patches/3rd_party/Thomasz-Torcz-systemd-2013-10-14.patch
Patch0:		%{name}-0001-add-systemd-unit-files.patch
# parts of MaraDNS a.. the files in coLunacyDNS/lunacy a.. are under MIT (Lua) license,
# but we don't package them
License:	BSD-2-Clause
URL:		http://www.maradns.org/

BuildRequires:	gcc
%{?systemd_requires}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires(pre):	shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils
Source44: import.info

%description
MaraDNS is a package that implements the Domain Name Service (DNS), an
essential internet service. MaraDNS has the following advantages:
	* Secure.
	* Supported.
	* Easy to use.
	* Small.
	* Open Source.

%prep
%setup -q
%patch0 -p1


%build

# We don't use %%configure here because this is a homebrew configure not generated by autoconf
./configure --ipv6 --libdir=%{_libdir}

# recursive resolver is shipped in versioned directory
# first compile Deadwood, otherwise we have no control over make flags
pushd deadwood-%{version}/src
%make_build FLAGS="%{optflags} -lrt"
popd
%make_build FLAGS="%{optflags} -DSELECT_PROBLEM -DAUTHONLY"


%install
# create /etc/maradns, /etc/mararc and /etc/dwood3rc first
install -p -d -m 0755 %{buildroot}%{_sysconfdir}/maradns/logger/
install -p -D -m 0644 doc/en/examples/example_mararc %{buildroot}%{_sysconfdir}/mararc
install -p -D -m 0644 deadwood-%{version}/doc/dwood3rc %{buildroot}%{_sysconfdir}/dwood3rc

# cache dir
install -p -d -m 0755 %{buildroot}/var/cache/deadwood

# sbin files
install -p -D -m 0755 server/maradns %{buildroot}%{_sbindir}/maradns
install -p -D -m 0755 tcp/zoneserver %{buildroot}%{_sbindir}/zoneserver
install -p -D -m 0755 deadwood-%{version}/src/Deadwood %{buildroot}%{_sbindir}/Deadwood

# bin files
install -p -D -m 0755 tcp/getzone %{buildroot}%{_bindir}/getzone
install -p -D -m 0755 tcp/fetchzone %{buildroot}%{_bindir}/fetchzone
install -p -D -m 0755 tools/askmara %{buildroot}%{_bindir}/askmara

# man pages
install -p -d -m 0755 %{buildroot}%{_mandir}/man{1,5,8}
install -p -D -m 0644 -t %{buildroot}%{_mandir}/man1/ \
	doc/en/man/askmara.1 \
	doc/en/man/getzone.1 \
	doc/en/man/fetchzone.1
install -p -D -m 0644 -t %{buildroot}%{_mandir}/man1/ \
	deadwood-%{version}/doc/Deadwood.1
install -p -D -m 0644 -t %{buildroot}%{_mandir}/man5/ \
	doc/en/man/csv1.5 \
	doc/en/man/csv2.5 \
	doc/en/man/csv2_txt.5 \
	doc/en/man/mararc.5
install -p -D -m 0644 -t %{buildroot}%{_mandir}/man8/ \
	doc/en/man/maradns.8 \
	doc/en/man/zoneserver.8 \

# systemd units
# NOTE: upstream ships slightly different named units
# migration to upstream units in Fedora will be done sometime in the future
mkdir -p %{buildroot}%{_unitdir}
install -p -D -m 0644 -t %{buildroot}%{_unitdir}/ \
	build/maradns.service \
	build/maradns-zoneserver.service \
	build/maradns-deadwood.service

%files
%doc doc/en/credits.txt doc/en/faq.txt doc/en/examples
%doc doc/en/credits.txt doc/en/faq.txt doc/en/tutorial
%doc doc/en/credits.txt doc/en/faq.txt doc/en/html
%doc --no-dereference COPYING
%config(noreplace) %{_sysconfdir}/mararc
%config(noreplace) %{_sysconfdir}/dwood3rc
%attr(-,maradns,maradns) %{_sysconfdir}/maradns/
%attr(-,maradns,maradns) /var/cache/deadwood/
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}-zoneserver.service
%{_unitdir}/%{name}-deadwood.service

%{_bindir}/askmara
%{_bindir}/fetchzone
%{_bindir}/getzone
%{_sbindir}/maradns
%{_sbindir}/zoneserver
%{_sbindir}/Deadwood

%{_mandir}/man1/askmara.1*
%{_mandir}/man1/getzone.1*
%{_mandir}/man1/fetchzone.1*
%{_mandir}/man1/Deadwood.1*
%{_mandir}/man5/csv1.5*
%{_mandir}/man5/csv2.5*
%{_mandir}/man5/csv2_txt.5*
%{_mandir}/man5/mararc.5*
%{_mandir}/man8/maradns.8*
%{_mandir}/man8/zoneserver.8*


%pre
if [ $1 -eq 1 ]; then
	getent group maradns >/dev/null || groupadd -r maradns
	getent passwd maradns >/dev/null || \
	useradd -r -g maradns -d /etc/maradns -s /sbin/nologin \
		-c "MaraDns chroot user" maradns
	exit 0
fi


%post
if [ $1 -eq 1 ]; then
	# correct UID/GID of maradns user
	sed --in-place -e "s/^maradns_uid.*/maradns_uid = $(id -u maradns)/" %{_sysconfdir}/mararc
	sed --in-place -e "s/^maradns_gid.*/maradns_gid = $(id -g maradns)/" %{_sysconfdir}/mararc
	sed --in-place -e "s/^maradns_uid.*/maradns_uid = $(id -u maradns)/" %{_sysconfdir}/dwood3rc
	sed --in-place -e "s/^maradns_gid.*/maradns_gid = $(id -g maradns)/" %{_sysconfdir}/dwood3rc
	# correct cache file directory
	sed --in-place -e 's@/etc/deadwood@/var/cache/deadwood@' %{_sysconfdir}/dwood3rc
fi
%post_service maradns
%post_service maradns-zoneserver
%post_service maradns-deadwood

%preun
%preun_service maradns
%preun_service maradns-zoneserver
%preun_service maradns-deadwood

%changelog
