# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          mathmod
Version:       11.1
Release:       alt1_1
Summary:       A program which generate 3D and 4D surfaces
Group:         Sciences/Mathematics
License:       GPLv2
URL:           https://sourceforge.net/projects/mathmod
Source0:       https://sourceforge.net/projects/mathmod/files/MathMod-%{version}/%{name}-%{version}-source.zip
Source1:       %{name}.1
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5OpenGL)
BuildRequires: pkgconfig(Qt5Widgets)
Provides:      k3dsurf = %{version}
Source44: import.info

%description
MathMod is a mathematical modeling software that visualize and
animate implicit and parametric surfaces.
MathMod supports:
3D and 4D plotting and animation
OBJ output file format
Scripting language compatible with JSON
Large set of scripted examples

%prep
%setup -q -n %{name}-%{version}

%build
%qmake_qt5
%make_build

%install
install -D -m755 MathMod %{buildroot}%{_bindir}/%{name}
install -D -m644 images/win/ico.png %{buildroot}%{_datadir}/pixmaps/%{name}.png
install -D -m644 %{SOURCE1} %{buildroot}%{_mandir}/man1/%{name}.1

# Create the system menu entry
mkdir -p  %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=MathMod
GenericName=3D and 4D surfaces generation
GenericName[it]=Grafici di funzioni 3D e 4D
GenericName[ru]=Генерация 3D и 4D поверхностей
Comment=Tool for mathematical surfaces
Comment[af]=Hulpmiddel vir wiskundige oppervlakke
Comment[sq]=Mjet për sipërfaqet matematike
Comment[ast]=Preséu pa superficies matemátiques
Comment[be]=Прылада для працы з матэматычнымі паверхнямі
Comment[bn]=গাণিতিক পৃষ্ঠতলের জন্য টুল
Comment[bs]=Alat za matematičke površine
Comment[pt_BR]=Ferramenta para superfícies matemáticas
Comment[bg]=Инструмент за математически повърхнини
Comment[ca]=Eina per a superfícies matemàtiques
Comment[ca@valencia]=Eina per a superfícies matemàtiques
Comment[crh]=Matematiksel yüzeyler için bir araç
Comment[zh_CN]=数学曲面工具
Comment[da]=Værktøj til matematiske overflader
Comment[cs]=Nástroj pro zobrazení matematického prostoru
Comment[nl]=Programma voor wiskundige oppervlaktes
Comment[fi]=Matemaattisten pintojen työkalu
Comment[fr]=Outil pour les surfaces mathématiques
Comment[gl]=Ferramenta para superficies matemáticas
Comment[de]=Werkzeug für mathematische Oberflächen
Comment[gd]=Inneal son uachdaran matamataig
Comment[el]=Εργαλείο για μαθηματικές επιφάνειες
Comment[hu]=Eszköz matematikai felületekhez
Comment[it]=Strumento per superfici matematiche
Comment[ja]=数学的な曲面ツール
Comment[ky]=Математикалык тегиздиктер менен иштөө үчүн шайман
Comment[lt]=Įrankis matematiniams paviršiams
Comment[ms]=Alat untuk permukaan matematik
Comment[oc]=Aisina per las susfàcias matematicas
Comment[nb]=Verktøy for matematiske overflater
Comment[pl]=Przekształcanie i wizualizacja wielowymiarowych powierzchni za pomocą matematycznych przekształceń
Comment[pt]=Ferramenta para superfícies matemáticas
Comment[ru]=Инструмент для работы с математическими поверхностями
Comment[ro]=Unealtă pentru suprafețe matematice
Comment[sk]=Nástroj na matematické povrchy
Comment[sl]=Orodje za matematične površine
Comment[sv]=Verktyg för matematiska ytor
Comment[es]=Herramienta para superficies matemáticas
Comment[tr]=Matematiksel yüzeyler için bir araç
Comment[uk]=Інструмент для роботи з математичними поверхнями
Comment[vi]=Công cụ bề mặt toán học
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Education;Science;Math;
EOF

%files
%doc documentation/*
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%{_mandir}/man1/%{name}.1*


%changelog
