Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mcrcon
Version:        0.7.2
Release:        alt1_7
Summary:        Console based rcon client for minecraft servers
License:        Zlib
URL:            https://github.com/Tiiffi/mcrcon/
Source0:        https://github.com/Tiiffi/mcrcon/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz
BuildRequires:  gcc
BuildRequires:  sed
Source44: import.info

%description
Mcrcon is powerful IPv6 compliant minecraft rcon client with bukkit coloring
support. It is well suited for remote administration and to be used as part of
automated server maintenance scripts. Does not cause "IO: Broken pipe" or
"IO: Connection reset" spam in server console.

Features:
- Interactive terminal mode - keeps the connection alive
- Send multiple commands in one command line
- Silent mode - does not print rcon output
- Support for bukkit coloring on Windows and Linux (sh compatible shells)
- Multiplatform code - compiles on many platforms with only minor changes

%prep
%setup -q

# Fix line endings
sed -i 's/\r$//' README.md

%build
%make_build CFLAGS="-std=gnu99" EXTRAFLAGS="%{?__global_cflags} %{?__global_ldflags}"

%install
%makeinstall_std PREFIX=%{_prefix}

%files
%doc --no-dereference LICENSE
%doc CHANGELOG.md README.md
%{_bindir}/mcrcon
%{_mandir}/man1/mcrcon.1*

%changelog
