# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(libmowgli)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name mcs
%define oname libmcs

%define major 1
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

Summary:	Modular Config System
Name:		mcs
Version:	0.7.2
Release:	alt1_14
License:	BSD
Group:		System/Libraries
Url:		https://github.com/atheme/libmcs
Source0:	http://distfiles.atheme.org/%{oname}-%{version}.tbz2
Patch0:		libmcs-0.7.1-linking.patch
Patch1:		libmcs-0.7.2-libmowgli.patch
BuildRequires:	pkgconfig(gconf-2.0)
BuildRequires:	pkgconfig(libmowgli-2)
Source44: import.info

%description
mcs is a library and set of userland tools which abstract the storage
of configuration settings away from userland applications.

It is hoped that by using mcs, that the applications which use it will
generally have a more congruent feeling in regards to settings.

There have been other projects like this before (such as GConf), but
unlike those projects, mcs strictly handles abstraction. It does not
impose any specific data storage requirement, nor is it tied to any
desktop environment or software suite.

%package	-n %{libname}
Group:		System/Libraries
Summary:	Modular Config System shared library
Requires:	%{name} >= %{version}

%description	-n %{libname}
mcs is a library and set of userland tools which abstract the storage
of configuration settings away from userland applications.

It is hoped that by using mcs, that the applications which use it will
generally have a more congruent feeling in regards to settings.

There have been other projects like this before (such as GConf), but
unlike those projects, mcs strictly handles abstraction. It does not
impose any specific data storage requirement, nor is it tied to any
desktop environment or software suite.

%package	-n %{develname}
Group:		Development/C
Summary:	Modular Config System shared library
Requires:	%{libname} = %{version}
Provides:	libmcs-devel = %{version}-%{release}
Obsoletes:	lib%{name}1-devel

%description	-n %{develname}
mcs is a library and set of userland tools which abstract the storage
of configuration settings away from userland applications.

It is hoped that by using mcs, that the applications which use it will
generally have a more congruent feeling in regards to settings.

There have been other projects like this before (such as GConf), but
unlike those projects, mcs strictly handles abstraction. It does not
impose any specific data storage requirement, nor is it tied to any
desktop environment or software suite.

%package	gconf
Group:		System/Libraries
Summary:	Modular Config System - GConf backend
Requires:	%{name} = %{version}

%description	gconf
mcs is a library and set of userland tools which abstract the storage
of configuration settings away from userland applications.

It is hoped that by using mcs, that the applications which use it will
generally have a more congruent feeling in regards to settings.

There have been other projects like this before (such as GConf), but
unlike those projects, mcs strictly handles abstraction. It does not
impose any specific data storage requirement, nor is it tied to any
desktop environment or software suite.

%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1
%patch1 -p1


%build
%configure --disable-kconfig
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS TODO README
%{_bindir}/mcs-*
%dir %{_libdir}/mcs/
%{_libdir}/mcs/keyfile.so

%files gconf
%{_libdir}/mcs/gconf.so

%files -n %libname
%{_libdir}/libmcs.so.%{major}*

%files -n %develname
%{_libdir}/libmcs.so
%{_libdir}/pkgconfig/libmcs.pc
%{_includedir}/libmcs/


%changelog
