Group: Text tools
# BEGIN SourceDeps(oneline):
BuildRequires: swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define		mainver		0.996
#%%define		betaver		pre3
%define		baserelease	7

# Note:
# mecab dictionary requires mecab-devel to rebuild it,
# and mecab requires mecab dictionary

Name:		mecab
Version:	%{mainver}
%if %{?betaver:0}%{!?betaver:1}
Release:	alt2_%{baserelease}
%else
Release:	alt3_0.%{baserelease}.%{betaver}
%endif
Summary:	Yet Another Part-of-Speech and Morphological Analyzer

# SPDX confirmed
License:	BSD-3-Clause OR LGPL-2.1-or-later OR GPL-2.0-or-later
URL:		http://mecab.sourceforge.net/
Source0:	http://mecab.googlecode.com/files/%{name}-%{version}.tar.gz

BuildRequires:	gcc-c++
Source44: import.info

%description
MeCab is a open source morphological analyzer which uses 
CRF (Conditional Random Fields) as the estimation of parameters.

NOTE:
You have to install MeCab dictionary rpm to make use
of MeCab.

%package devel
Group: Development/Other
Summary:	Libraries and Header files for Mecab
Requires:	%{name}%{?isa} = %{version}-%{release}

%description devel
This is the development package that provides header files and libraries
for MeCab.

%prep
%setup -q -n %{name}-%{mainver}%{?betaver}


mv doc/doxygen .
find . -name \*.cpp -print0 | xargs -0 chmod 0644

# compiler flags fix
sed -i.flags \
	-e '/-O3/s|CFLAGS=\"\(.*\)\"|CFLAGS=\${CFLAGS:-\1}|' \
	-e '/-O3/s|CXXFLAGS=\"\(.*\)\"|CXXFLAGS=\${CFLAGS:-\1}|' \
	-e '/MECAB_LIBS/s|-lstdc++||' \
	configure

# multilib change
sed -i.multilib \
	-e 's|@prefix@/lib/mecab|%{_libdir}/mecab|' \
	mecab-config.in mecabrc.in

%build
%configure
# remove rpath from libtool
sed -i.rpath \
	-e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
	-e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' \
	libtool

%make_build

%install
%makeinstall_std

rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.{a,la}
rm -f doc/Makefile*

# create directory
mkdir -p $RPM_BUILD_ROOT%{_libdir}/mecab/dic/

%check
# here enable rpath
export LD_LIBRARY_PATH=$(pwd)/src/.libs
cd tests
%{__make} check || :
cd ..



%files
%doc AUTHORS
%doc --no-dereference BSD COPYING GPL LGPL
%doc doc/ example/
%{_mandir}/man1/%{name}.1*

%config(noreplace) %{_sysconfdir}/mecabrc
%{_bindir}/%{name}
%{_libexecdir}/%{name}/
%{_libdir}/lib%{name}.so.2*
# several dictionaries can install data files
# into the following directory.
%dir %{_libdir}/%{name}/
%dir %{_libdir}/%{name}/dic/

%files devel
%doc doxygen/
%{_bindir}/%{name}-config
%{_libdir}/lib%{name}.so
%{_includedir}/%{name}.h

%changelog
