%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: Development/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?tcl_version: %global tcl_version %(echo 'puts $tcl_version' | tclsh)}
%{!?tcl_sitearch: %global tcl_sitearch %{_libdir}/tcl%{tcl_version}}

Name:           memchan
Version:        2.3
Release:        alt2_28
Summary:        In-memory channels for Tcl
# All files MIT except isaac/rand.h and isaac/randport.c which
# are public domain.
License:        MIT and Public Domain
URL:            http://memchan.sourceforge.net/
Source0:        http://downloads.sourceforge.net/%{name}/Memchan%{version}.tar.gz
BuildRequires:  gcc
BuildRequires:  tcl-devel, tcllib
Source44: import.info

%description
Memchan is an extension library to the script language Tcl, as created by John
Ousterhout. It provides several new channel types for in-memory channels and
the appropriate commands for their creation.

%package devel
Group: Development/Other
Summary: Development files for compiling against the Tcl memchan extension
Requires: %{name} = %{version}-%{release}
%description devel
Development files for compiling against the Tcl memchan extension

%prep
%setup -q -n Memchan%{version}

%build
%configure --enable-threads --libdir=%{tcl_sitearch}
%make_build

%install
make install DESTDIR=%{buildroot}

# Remove a man page that conflicts with tclib
rm -f %{buildroot}%{_mandir}/mann/random.n

# Remove +x perm on stub library
chmod -x %{buildroot}%{tcl_sitearch}/Memchan%{version}/*.a

%check
make test

%files
%doc ChangeLog
%doc --no-dereference doc/license.terms
%{_mandir}/mann/**
%dir %{tcl_sitearch}/Memchan%{version}
%{tcl_sitearch}/Memchan%{version}/*.so
%{tcl_sitearch}/Memchan%{version}/*.tcl

%files devel
%{_includedir}/*.h
# Please note: This is not a traditional static library.
# This is the stub library for linking against memchan.  Tcl stub libraries
# are a cross-platform cross-compiler way of performing dynamic linking.  So even
# though it's a static library, it's really used for dynamic linking:
# http://wiki.tcl.tk/285
%{tcl_sitearch}/Memchan%{version}/*.a

%changelog
