Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This is really a noarch package, we're just building on all arches so we 
# can run unit tests across all arches.   The debuginfo will always be empty
# (no executables or libraries,) so we can disable it
%global debug_package %{nil}

Name:           metslib
Version:        0.5.3
Release:        alt2_30
Summary:        Metaheuristic modeling framework and optimization toolkit in modern C++

License:        GPLv3+ or CPL
URL:            https://projects.coin-or.org/metslib
Source0:        http://www.coin-or.org/download/source/%{name}/%{name}-%{version}.tgz
# Removes all "libdir" paths from .pc file (which are unneeded).  Not upstream
Patch0:         %{name}-0.5.3-noarch.patch
# Port metslib to use boost random functionality instead of outdated tr1
# Based on https://github.com/PointCloudLibrary/pcl/commit/57ace9a92d1667eaa6193262032ff688e222ce0f
# Not upstream
Patch1:         %{name}-0.5.3-boost.patch
# Update abstract-search.hpp to remove deprecated exception specification
# Not upstream
Patch2:         %{name}-0.5.3-cpp17.patch

BuildRequires:  gcc-c++
BuildRequires:  doxygen
BuildRequires:  boost-complete
BuildRequires:  graphviz libgraphviz
Source44: import.info

%description
%{summary}.

%package        devel
Group: Other
Summary:        Metaheuristic modeling framework and optimization toolkit in modern C++
Provides:       %{name}-static = %{version}-%{release}
BuildArch:      noarch
Requires:       boost-complete

%description    devel
METSlib is a metaheuristic modeling framework and optimization toolkit in
modern C++ released as Free/Libre/Open Source Software.

Model and algorithms are modular: any search algorithm can be applied to the
same model. On the other hand no assumption is made on the model, you can
work on any problem type: timetabling, assignment problems, vehicle routing,
bin-packing and so on.

Once you have implemented your model in the problem framework, the library
makes easy testing different Tabu Search strategies or even different
algorithms (Simulated Annealing or other local search based algorithms) with
a few lines of code.

%package doc
Group: Other
Summary:     Documentation for %{name}
BuildArch:   noarch

%description doc
The %{name}-doc package provides documentation for the %{name} library.

%prep
%setup -q
%patch0 -p0
%patch1 -p1 -b .boost
%patch2 -p1 -b .cpp17
# Disable -O3 optimization for unit tests
sed -i 's| -O3||g' configure

%build
export CXXFLAGS="%{optflags} --std=gnu++14"
%configure 
%make_build
doxygen doxydoc/doxygen.conf

%install
%makeinstall_std
# Move pkgconfig file to /usr/share/pkgconfig (since package is noarch)
mkdir -p %{buildroot}%{_datadir}
mv %{buildroot}%{_libdir}/pkgconfig %{buildroot}%{_datadir}

%check
export CXXFLAGS="%{optflags}" 
make test

%files devel
%doc AUTHORS COPYING NEWS README 
%{_includedir}/*
%{_datadir}/pkgconfig/*.pc

%files doc
%doc doxydoc/html COPYING

%changelog
