# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname   Miam-Player

Name:           miam-player
Version:        0.8.0
Release:        alt1_7
Summary:        A nice music player
Group:          Sound
License:        GPLv3+
URL:            http://www.miam-player.org/
# Repacked to remove windows packaging and dlls
Source0:        %{oname}-%{version}.tar.xz
Patch0:         miam-player-0.8.0-mga-qxt-x11-linking.patch
Patch1:         miam-player-0.8.0-mga-desktop.patch
Patch2:         miam-player-0.8.0-fix-build-against-qt-5.11.0.patch

BuildRequires:  ImageMagick-tools
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Multimedia)
BuildRequires:  pkgconfig(Qt5Sql)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5X11Extras)
BuildRequires:  pkgconfig(taglib)
BuildRequires:  libqtav-devel
Requires:       libqt5-sql
Source44: import.info

%description
Miam Player is a cross-platform open source music player based on Qt5:

 - Read .mp3, .m4a (MP4), .flac, .ogg, .oga (OGG Vorbis), .asf, .ape
   (Monkey Audio) and more
 - Read and edit lots of tags using Taglib
 - Customize everything: user interface, covers, shortcuts, buttons, themes
 - Fast and reliable (audio player is provided by VLC Media Player)

A plugin system makes it possible to extend the possibilites of the player.

%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
rm -rf src/Core/3rdparty/{taglib,QtAV}

%build
%qmake_qt5 LIB_SUFFIX=%(echo %{_lib} | sed -e 's/lib//')
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

# Remove .so symlinks to prevent requiring devel libraries
rm -f %{buildroot}%{_libdir}/*.so

%files
%doc README.md
%{_bindir}/%{name}
%{_libdir}/libmiam-core.so.*
%{_libdir}/libmiam-library.so.*
%{_libdir}/libmiam-uniquelibrary.so.*
%{_libdir}/libmiam-tabplaylists.so.*
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/application-x-miamplayer.png


%changelog
