Group: System/Servers
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Milter header files package name
%if (0%{?rhel} && 0%{?rhel} <= 7) || (0%{?fedora} && 0%{?fedora} <= 25)
%global milter_devel_package sendmail-devel
%else
%global milter_devel_package sendmail-milter-devel
%endif

Name:		milter-regex
Version:	2.7
Release:	alt2_13
Summary:	Milter plug-in for regular expression filtering
License:	BSD-2-Clause
URL:		http://www.benzedrine.ch/milter-regex.html
Source0:	http://www.benzedrine.ch/milter-regex-%{version}.tar.gz
# Note: signature made with ancient PGP key, needs gpg1 to verify
Source10:	http://www.benzedrine.ch/milter-regex-%{version}.tar.gz.asc
Source1:	milter-regex.service
Source2:	milter-regex-options
Source3:	milter-regex.conf
BuildRequires:	bison
BuildRequires:	coreutils
BuildRequires:	gcc
BuildRequires:	groff-base groff-dvi groff-extra groff-lbp groff-lj4
BuildRequires:	sendmail-devel >= 8.13
BuildRequires:	sed
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires(pre):	shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils
%{?systemd_requires}
Source44: import.info

%description
Milter-regex is a milter based filter that makes it possible to filter
emails using regular expressions.

%prep
%setup -q

# Customize config file location and dæmon user
sed -i -e	's|/etc/milter-regex\.conf|%{_sysconfdir}/mail/milter-regex.conf|;
		 s|_milter-regex|mregex|' milter-regex.[8c]

# Copy out the license text from the source code
head -n +31 milter-regex.c > LICENSE

%build
%make_build -f Makefile.linux \
	CFLAGS="%{optflags} -Wextra -Wwrite-strings -DYYMAXDEPTH=8192" \
	LDFLAGS="-Wl,-z,now -Wl,-z,relro %{?__global_ldflags} -Wl,--as-needed -L/usr/lib/libmilter -lmilter -lpthread"

%install
mkdir -p \
	%{buildroot}%{_unitdir} \
	%{buildroot}%{_localstatedir}/spool/milter-regex \
	%{buildroot}%{_mandir}/man8 \
	%{buildroot}%{_sbindir} \
	%{buildroot}%{_sysconfdir}/{mail,sysconfig}
install -p -m 755 milter-regex %{buildroot}%{_sbindir}/
install -p -m 644 milter-regex.8 %{buildroot}%{_mandir}/man8/
install -p -m 644 %{SOURCE1} %{buildroot}%{_unitdir}/milter-regex.service
install -p -m 644 %{SOURCE2} %{buildroot}%{_sysconfdir}/sysconfig/milter-regex
install -p -m 644 %{SOURCE3} %{buildroot}%{_sysconfdir}/mail/milter-regex.conf

# Create a ghost sock file so we can remove it on package deletion
: > %{buildroot}%{_localstatedir}/spool/milter-regex/sock
for rpm404_ghost in %{_localstatedir}/spool/milter-regex/sock
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%pre
getent group mregex >/dev/null || groupadd -r mregex
getent passwd mregex >/dev/null || \
	useradd -r -g mregex -d %{_localstatedir}/spool/milter-regex \
		-s /sbin/nologin -c "Regex Milter" mregex
exit 0

%post
%post_service milter-regex

%preun
%preun_service milter-regex

%files
%doc --no-dereference LICENSE
%{_sbindir}/milter-regex
%{_unitdir}/milter-regex.service
%config(noreplace) %{_sysconfdir}/sysconfig/milter-regex
%config(noreplace) %{_sysconfdir}/mail/milter-regex.conf
%dir %attr(755,root,mregex) %{_localstatedir}/spool/milter-regex/
%ghost %{_localstatedir}/spool/milter-regex/sock
%{_mandir}/man8/milter-regex.8*

%changelog
