Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mined
Version:        2015.25
Release:        alt1_7
Summary:        Powerful Text Editor with Extensive Unicode and CJK Support
Summary(fr):    Puissant éditeur de texte avec Unicode Extensible et support de CJK
License:        GPLv3
URL:            http://towo.net/mined/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch0:         fix-timestmp-gcc-command.patch
Patch1:         fix-armv7hl-build-in-configure-script.patch
BuildRequires:  gcc
BuildRequires:  desktop-file-utils
BuildRequires:  libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
Source44: import.info


%description
Mined is the first text editor that provided Unicode support in a plain-text
terminal. It now has both extensive Unicode and CJK support offering
many specific features and covering special cases that other editors
are not aware of (like auto-detection features and automatic handling of
terminal variations or Han character information). Basically, it is an
editor tailored to efficient editing of plain text documents and
programs with features and interactive behavior designed for this
purpose.

%description -l fr
Mined est le premier éditeur de texte qui fourni le support Unicode dans un
terminal en texte brut. Il possède maintenant à la fois l'Unicode extensible
et le support de CJK offrant beaucoup de traits spécifiques et couvre les
cas spéciaux que les autres éditeurs n'ont pas conscience (comme
l'auto-détection des caractéristiques et la manipulation des variations entre
les terminaux ou l'information de caractères Han). Fondamentalement, c'est
un éditeur taillé pour l'édition efficace de document en texte brut et
programmes avec des caractéristiques et des comportements interactifs conçus
à cet effet.


%package -n xmined
Group: Other
Summary:        Graphical interface using Xterm of Mined text editor
Summary(fr):    Interface graphique utilisant Xterm pour éditeur de texte Mined
Requires:       xterm
Requires:       %{name} = %{version}-%{release}

%description -n xmined
Mined is the first text editor that provided Unicode support in a plain-text
terminal. It now has both extensive Unicode and CJK support offering
many specific features and covering special cases that other editors
are not aware of (like auto-detection features and automatic handling of
terminal variations or Han character information). Basically, it is an
editor tailored to efficient editing of plain text documents and
programs with features and interactive behavior designed for this
purpose.

%description -n xmined -l fr
Mined est le premier éditeur de texte qui fourni le support Unicode dans un
terminal en texte brut. Il possède maintenant à la fois l'Unicode extensible
et le support de CJK offrant beaucoup de traits spécifiques et couvre les
cas spéciaux que les autres éditeurs n'ont pas conscience (comme
l'auto-détection des caractéristiques et la manipulation des variations entre
les terminaux ou l'information de caractères Han). Fondamentalement, c'est
un éditeur taillé pour l'édition efficace de document en texte brut et
programmes avec des caractéristiques et des comportements interactifs conçus
à cet effet.


%prep
%setup -q
# Delete file for Windows :
rm -f ./usrshare/bin/wined.bat
# For rpmlint warning "dangling-relative-symlink" in mined package :
# Symlinks are: CHANGES -> usrshare/package_doc/CHANGES -> usrshare/doc_user/changes.html
rm -f ./CHANGES
cp -p ./usrshare/doc_user/changes.html ./CHANGES
# Convert to UTF8 mined.1.gz and CHANGES :
for f in CHANGES man/%{name}.1; do
  iconv -f iso-8859-1 -t utf8 $f >$f.tmp && \
  touch -r $f $f.tmp && \
  mv $f.tmp $f
done
# Fix desktop-file-validate warning: remove .xpm suffix from icon filename :
sed -i "s/mined.xpm/mined/" ./usrshare/setup_install/mined.desktop
# Fix desktop-file-validate warning: semicolon missing for Categories key :
sed -i s/Utility/Utility\;/ ./usrshare/setup_install/mined.desktop
%patch0 -p0
%patch1 -p0


%build
./configure
# Optflag isn't applied by default :
make OPT='%{optflags}' USRLIBDIR=%{_libdir} ROOTLIBDIR=/%{_lib} %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}
# Install mined.desktop and fix desktop-file-validate warning :
desktop-file-install --remove-key Encoding                      \
                     --dir=%{buildroot}%{_datadir}/applications \
%{buildroot}%{_datadir}/%{name}/setup_install/%{name}.desktop
# Remove files for Windows but needed for build
# and useless directory (package_doc, doc_user) :
rm -fr %{buildroot}%{_datadir}/%{name}/{bin,setup_install,conf_user,package_doc,doc_user}


%files
%doc ./usrshare/package_doc/README ./usrshare/doc_user DESCR CHANGES LICENCE.GPL VERSION
%{_bindir}/%{name}
%{_bindir}/minmacs
%{_bindir}/mpico
%{_bindir}/mstar
%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/minmacs.1*
%{_mandir}/man1/mpico.1*
%{_mandir}/man1/mstar.1*
%{_datadir}/%{name}/

%files -n xmined
%{_bindir}/umined
%{_bindir}/uterm
%{_bindir}/xmined
%{_mandir}/man1/umined.1*
%{_mandir}/man1/uterm.1*
%{_mandir}/man1/xmined.1*
%{_datadir}/pixmaps/%{name}.xpm
%{_datadir}/applications/%{name}.desktop


%changelog
