Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           minetestmapper
Version:        20220221
Release:        alt1_6
Summary:        Generates a overview image of a minetest map

License:        BSD
URL:            https://github.com/minetest/minetestmapper
Source0:        https://github.com/minetest/minetestmapper/archive/%{version}/minetestmapper-%{version}.tar.gz

BuildRequires:  gcc-c++ ctest cmake, libsqlite3-devel, libgd3-devel, libleveldb-devel, libhiredis-devel, libpq5-devel, libzstd-devel

# Wants minetest for ownership of /usr/share/minetest.
# But there's no reason it should *require* minetest.
Requires:       minetest
Source44: import.info

%description
Generates a overview image of a minetest map. This is a port of
minetestmapper.py to C++, that is both faster and provides more
details than the deprecated Python script.

%prep
%setup -q


# https://github.com/minetest/minetestmapper/issues/57
sed 's/get_setting/read_setting/g' -i db-postgresql.cpp

%build
%{fedora_v2_cmake} -DENABLE_LEVELDB=1 -DENABLE_REDIS=1 -DENABLE_POSTGRESQL=1
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

# Install colors.txt into /usr/share/minetest.
mkdir -p %{buildroot}%{_datadir}/minetest
cp -a colors.txt %{buildroot}%{_datadir}/minetest/

# Remove copy of license from docdir.
rm -rf %{buildroot}%{_docdir}/%{name}/COPYING

%files
%{_bindir}/minetestmapper
%{_datadir}/minetest/
%{_datadir}/minetest/colors.txt
%{_mandir}/man6/minetestmapper.6*
%doc --no-dereference COPYING
%doc AUTHORS README.rst

%changelog
