# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# -*- mode: rpm-spec ; mode: font-lock -*-

Summary: Macromolecular coordinate library
Name: mmdb
Version: 1.25
Release: alt1_4
License: LGPLv3
Group: System/Libraries
URL: ftp://ftp.ccp4.ac.uk/opensource/
Source0: ftp://ftp.ccp4.ac.uk/opensource/%{name}-%{version}.3.tar.gz
Source44: import.info

%description
MMDB is a macromolecular coordinate library, written by Eugene
Krissinel primarily for use by the collaborative computational project
4 (CCP4) group in the United Kingdom.  The Coordinate Library is
designed to assist CCP4 developers in working with coordinate files.

The Library features work with the primary file formats of the Protein
Data Bank (PDB), the PDB file format and the mmCIF file format.

The Library provides various high-level tools for working with
coordinate files, which include not only reading and writing, but also
orthogonal-fractional coordinate transforms, generation of symmetry
mates, editing the molecular structure and some others. The Library is
supposed as a general low-level tool for unifying the
coordinate-related operations.

This package contains the shared library components needed for programs
that have been compiled with the mmdb library. 

%package devel
Summary: Header files and library for developing programs with mmdb
Requires: %{name} = %{version}-%{release}
Group: Development/C

%description devel

This package contains libraries and header files needed for program
development using the macromolecular coordinate library.

%prep
%setup -q -n %{name}-%{version}.3

%build
%configure --enable-shared --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p'

# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%files
%doc AUTHORS COPYING README
%{_libdir}/libmmdb.so.0.0.0
%{_libdir}/libmmdb.so.0

%files devel
%{_libdir}/libmmdb.so
%{_includedir}/mmdb/
%{_libdir}/pkgconfig/%{name}.pc

%changelog
