Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Macromolecular coordinate library
Name: mmdb2
Version: 2.0.1
Release: alt2_23
License: LGPLv3
URL: ftp://ftp.ccp4.ac.uk/opensource/
Source0: ftp://ftp.ccp4.ac.uk/opensource/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  gcc-c++
Source44: import.info

%description
MMDB is a macromolecular coordinate library, written by Eugene
Krissinel primarily for use by the collaborative computational project
4 (CCP4) group in the United Kingdom.  The Coordinate Library is
designed to assist CCP4 developers in working with coordinate files.

The Library features work with the primary file formats of the Protein
Data Bank (PDB), the PDB file format and the mmCIF file format.

The Library provides various high-level tools for working with
coordinate files, which include not only reading and writing, but also
orthogonal-fractional coordinate transforms, generation of symmetry
mates, editing the molecular structure and some others. The Library is
supposed as a general low-level tool for unifying the
coordinate-related operations.

This package contains the shared library components needed for programs
that have been compiled with the mmdb library. 

%package devel
Group: Development/Other
Summary: Header files and library for developing programs with mmdb
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package contains libraries and header files needed for program
development using the macromolecular coordinate library.

%prep
%setup -q -n %{name}-%{version}
chmod 644 README COPYING AUTHORS

%build
%configure --enable-shared --disable-static
%make_build

%install
make install DESTDIR=%{buildroot} INSTALL='install -p'

# remove unpackaged files from the buildroot
rm -f %{buildroot}%{_libdir}/*.la



%files
%doc AUTHORS COPYING README
%{_libdir}/libmmdb2.so.0.0.0
%{_libdir}/libmmdb2.so.0

%files devel
%{_libdir}/libmmdb2.so
%{_includedir}/mmdb2/
%{_libdir}/pkgconfig/%{name}.pc

%changelog
