# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum	Classic-style JRPG and prequel to Monster RPG 2

Name:           monster
Version:        1.24
Release:        alt1_9
Summary:        %{sum}
Group:          Games/Adventure
License:        BSD
URL:            https://github.com/Nooskewl/monster

Source0:        %{name}-%{version}.tar.xz
#Source0:        https://github.com/Nooskewl/monster/archive/%{version}/%{name}-%{version}.tar.gz
Patch0:         monster-1.24-mga-data-path.patch
Patch1:         monster-1.24-gcc7.patch
Patch2:		monster-1.24-allegra.patch
Patch3:		monster-1.24-git-logg_stream.patch

BuildRequires:  liballegro-devel
BuildRequires:  libfudgefont-devel
BuildRequires:  lua5.1-devel
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  pkgconfig(zlib)
Source33: loggint.h
Source44: import.info

%description
Monster 1 is a classic-style JRPG in the theme of old NES titles of the 80s
and 90s. Like those RPGs, you gain experience and level up through combat,
while talking to characters and advancing in your quest to save your child
from the hands of a monster.

Monster 1 is a "loose prequel" to the Monster RPG 2 game.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

sed -i 's/lua5.1/lua-5.1/' src/Makefile.unix
mkdir oldallegro
cp %SOURCE33 oldallegro/loggint.h

%build
%add_optflags -std=c++14
%add_optflags -I../oldallegro
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS
# Build custom GUI library
make -C tgui-0.9 -f Makefile.unix
%make_build -C src -f Makefile.unix SHARED=1

%install
install -D -m755 src/monster %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data/* %{buildroot}%{_gamesdatadir}/%{name}

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Monster 1
Comment=%{sum}
GenericName=Classic-style JRPG
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;RolePlaying;
EOF

install -D -m644 icon.png %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
install -D -m644 icon512.png %{buildroot}%{_datadir}/icons/hicolor/512x512/apps/%{name}.png

%files
%doc README.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png


%changelog
