# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define		bin_name mp-5
%define		upstream_name %{bin_name}.x

%bcond_with pcre

Name:		mp
Version:	5.61
Release:	alt1_1
Summary:	Minimum Profit Text Editor
Group:		Editors
License:	GPLv2
URL:		https://triptico.com/software/mp.html
Source0:	https://github.com/ttcdt/mp-5.x/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:	bison
BuildRequires:	flex
BuildRequires:	mp_doccer
%if %{with pcre}
BuildRequires:	pkgconfig(libpcre)
%endif
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Widgets)
BuildRequires:	libncurses++-devel libncursesw-devel
BuildRequires:	grutatxt
BuildRequires:	glibc-devel glibc-devel-static
BuildRequires:	gettext gettext-tools

Provides:	%{name}-5 = %{version}-%{release}
Source44: import.info

%description
A text editor for programmers including the following features:

- Fully scriptable using a C-like scripting language.
- Unlimited undo levels.
- Complete Unicode support.
- Multiple files can be edited at the same time and blocks copied and pasted
  among them.
- Syntax highlighting for many popular languages / file formats: C, C++, Perl,
  Shell Scripts, Ruby, Php, Python, HTML...
- Creative use of tags: tags created by the external utility ctags are used to
  move instantaneously to functions or variables inside your current source
  tree. Tags are visually highlighted (underlined), and symbol completion can
  be triggered to avoid typing your own function names over and over.
- Intelligent help system: pressing F1 over any word of a text being edited
  triggers the underlying system help (calling man when editing C or Shell
  files, perldoc with Perl, ri on Ruby...).
- Understandable interface: drop-down menus, reasonable default key bindings.
- Configurable keys, menus and colors.
- Text templates can be easily defined / accessed.
- Multiplatform: Console/curses, Qt4, KDE4, GTK+, MS Windows (both windowed
  and console).
- Automatic indentation, word wrapping, internal grep, learning / repeating
  functions.
- Spellchecking support (via the ispell package).
- Multilingual.
- Password-protected, encrypted text files (using the ARCFOUR algorithm).
- It helps you abandon vi, emacs and other six-legged freaks definitely.

%prep
%setup -q -n %{upstream_name}-%{version}


%build

# An error with Qt5 detection and compilation occurs without this setting
#export CPP="g++ -std=gnu++11"
export CFLAGS="%{optflags} -fpermissive"
./config.sh \
	--prefix=%{_prefix} \
	--with-moc=%{_qt5_bindir}/moc \
	--with-qt5 \
	--without-qt4 \
	--without-gtk \
	--without-win32 \
	%{?with_pcre:--with-pcre} \
	--with-curses
%make_build

%install
mkdir -p %{buildroot}%{_bindir}

%makeinstall_std DESTDIR=%{buildroot}

( cd %{buildroot}%{_bindir} && ln -s mp-5 mp )
# Debian uses "mped" for this application
( cd %{buildroot}%{_bindir} && ln -s mp-5 mped )

# Make the man page
grutatxt -m man -t "Minimum Profit" < doc/mp_man.txt > %{bin_name}.1
install -m 0644 %{bin_name}.1 %{buildroot}%{_mandir}/man1/%{bin_name}.1

#find_lang mp

%files
#-f mp.lang
%doc --no-dereference LICENSE
%doc README RELEASE_NOTES *sample TODO* doc/*
%doc mpsl/README* mpsl/doc/*
%doc mpdm/doc/*
%{_docdir}/%{bin_name}/
%{_bindir}/%{bin_name}
%{_bindir}/%{name}
%{_bindir}/%{name}ed
#_bindir/mpsl
#_datadir/#{bin_name}/
%{_mandir}/man1/%{bin_name}*


%changelog
