# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name mpfrcx
%define libmajor	1
%define libname		lib%{name}%{libmajor}
%define libname_devel	lib%{name}-devel

Summary:	Arithmetic of univariate polynomials over arbitrary precision real (Mpfr) or complex (Mpc) numbers
Name:		mpfrcx
Version:	0.4.2
Release:	alt1_5
License:	LGPLv2+
Group:		System/Libraries
URL:		http://www.multiprecision.org/%{name}
Source0:	http://www.multiprecision.org/downloads/%{name}-%{version}.tar.gz
BuildRequires:	libgmp-devel >= 4.3.2
BuildRequires:	libmpfr-devel >= 2.4.2
BuildRequires:	libmpc-devel >= 1.0

Patch0:		mpfrcx-0.4.2-replace-__gmp_const-with-const.patch
Source44: import.info

%description
Mpfrcx is a library for the arithmetic of univariate polynomials over
arbitrary precision real (Mpfr) or complex (Mpc) numbers, without control
on the rounding. For the time being, only the few functions needed to
implement the floating point approach to complex multiplication are implemented.
On the other hand, these comprise asymptotically fast multiplication routines
such as Toom-Cook and the FFT.

%package	-n %{libname}
Summary:	Arithmetic of complex numbers with arbitrarily high precision and correct rounding
Group:		System/Libraries

%description	-n %{libname}
Mpfrcx is a library for the arithmetic of univariate polynomials over
arbitrary precision real (Mpfr) or complex (Mpc) numbers, without control
on the rounding. For the time being, only the few functions needed to
implement the floating point approach to complex multiplication are implemented.
On the other hand, these comprise asymptotically fast multiplication routines
such as Toom-Cook and the FFT.

%package	-n %{libname_devel}
Summary:	Development headers and libraries for MPFRCX
Group:		Development/C
Requires:	%{libname} = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}

%description	-n %{libname_devel}
Development headers and libraries for MPFRCX.

%prep
%setup -q
%patch0 -p1


%build
# fix build on aarch64
autoreconf -vfi

%configure			\
	--enable-shared		\
	--disable-static

%make_build

%install
%makeinstall_std

rm -f %{buildroot}%{_libdir}/*.la

%check
make check

%files -n %{libname}
%doc AUTHORS NEWS README TODO
%{_libdir}/libmpfrcx.so.%{libmajor}
%{_libdir}/libmpfrcx.so.%{libmajor}.*

%files -n %{libname_devel}
%{_includedir}/mpfrcx.h
%{_infodir}/mpfrcx.info*
%{_libdir}/libmpfrcx.so


%changelog
