Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global modulename msoffcrypto

Summary:        Python tool for decrypting MS Office files with passwords or other keys
Name:           msoffcrypto-tool
Version:        4.11.0
Release:        alt2_8
License:        MIT
URL:            https://github.com/nolze/msoffcrypto-tool
Source:         https://github.com/nolze/msoffcrypto-tool/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  python3-module-cryptography >= 2.3
BuildRequires:  python3-module-olefile >= 0.45
# Tests
BuildRequires:  pytest3 python3-module-pytest

Requires:       python3-module-msoffcrypto
Source44: import.info

%description
The msoffcrypto-tool (formerly ms-offcrypto-tool) is a Python tool and
library for decrypting encrypted Microsoft Office files with password,
intermediate key, or private key which generated its escrow key.

%package -n python3-module-msoffcrypto
Group: Other
Summary:        Python library for decrypting MS Office files with passwords or other keys
Requires:       python3-module-cryptography >= 2.3
Requires:       python3-module-olefile >= 0.45
%{?python_provide:%python_provide python3-%{modulename}}

%description -n python3-module-msoffcrypto
The msoffcrypto-tool (formerly ms-offcrypto-tool) is a Python tool and
library for decrypting encrypted Microsoft Office files with password,
intermediate key, or private key which generated its escrow key.

%prep
%setup -q

%build
%python3_build

%install
%python3_install

%check
%if 0%{?rhel} && 0%{?rhel} < 8
pytest-3
%else
py.test-3
%endif

%files
%doc README.md
%{_bindir}/%{name}

%files -n python3-module-msoffcrypto
%doc --no-dereference LICENSE.txt
%{python3_sitelibdir_noarch}/%{modulename}/
%{python3_sitelibdir_noarch}/%{modulename}_tool-%{version}-py%{__python3_version}.egg-info/

%changelog
