Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: libutf8proc-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:       Sort files in sophisticated ways
Name:          msort
Version:       8.53
Release:       alt4_53
License:       GPLv3
URL:           http://billposer.org/Software/msort.html
Source0:       http://billposer.org/Software/Downloads/msort-%{version}.tar.bz2
Patch0:        msort-8.53-dso.patch
Patch1:        msort-8.53-format.patch
Patch2:        msort-8.53-mlimits.patch
Patch3:        msort-configure-c99.patch
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gcc
BuildRequires: libgmp-devel libgmpxx-devel
BuildRequires: icu-utils libicu-devel
BuildRequires: libuninum-devel >= 2.5
BuildRequires: libtre-devel >= 0.8.0
Requires:      iwidgets
Source44: import.info
%description
Msort is a program for sorting files in sophisticated ways. Records
need not be single lines. Key fields may be selected by position, tag,
or character range. For each key, distinct exclusions, multigraphs,
substitutions. and a sort order may be defined. Comparisons may be
lexicographic, numeric, by string length, date, or time. Optional keys
are supported. Msort uses the Unicode character set and provides full
Unicode case-folding. The basic program has a somewhat complex command
line interface, but may be driven by an optional GUI.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
aclocal
automake --add-missing --copy
autoconf
export LDFLAGS="%{__global_ldflags} -fPIC"
export CFLAGS="%{optflags}"
%configure --disable-utf8proc
%make_build CFLAGS="%{optflags} -fPIC" LDFLAGS="%{__global_ldflags} -fPIC"

%install
make DESTDIR=%{buildroot} install
install -p -m 0644 -D msort.1 %{buildroot}%{_mandir}/man1/msort.1

%check
touch hybrid-ips.txt
./msort -ql -t SRC= -c h -t DST= -c h hybrid-ips.txt
rm hybrid-ips.txt

%files
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog Doc/* NEWS README TODO
%{_bindir}/msg
%{_bindir}/msort
%{_mandir}/man1/msort.1*

%changelog
