# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Curses.pm) perl(DBD/Pg.pm) perl(DB_File.pm) perl(File/Copy/Recursive.pm) perl(File/Slurp.pm) perl(IO/Scalar.pm) perl(IO/Socket/INET6.pm) perl(List/MoreUtils.pm) perl(Net/Server/Daemonize.pm) perl(Net/Server/Fork.pm) perl(Pod/Perldoc.pm) perl(Pod/Simple/SimpleTree.pm) perl(Pod/Simple/TextContent.pm) perl(Pod/Usage.pm) perl(RRDs.pm) perl(SDBM_File.pm) perl(Term/Size.pm) perl(Test/Deep.pm) perl(Test/Differences.pm) perl(Test/LongString.pm) perl(Test/MockObject/Extends.pm) perl(Test/More.pm) perl(Text/Balanced.pm) perl(URI.pm) perl(URI/_server.pm) perl-devel perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^.usr.ucb.ps/d
%add_findreq_skiplist %_datadir/munin/plugins/http_loadtime
BuildRequires: perl(Date/Manip.pm) perl(CGI/Fast.pm) perl(FCGI.pm) perl(Net/DNS.pm) perl(bigint.pm) perl(Tie/File.pm) perl(Net/IP.pm) perl(XML/LibXML.pm)
%define fedora 21
Name:           munin
Version:        2.0.25
Release:        alt8_5
Summary:        Network-wide graphing framework (grapher/gatherer)

Group:          System/Servers
License:        GPLv2
URL:            http://munin-monitoring.org/
Source0:        http://downloads.sourceforge.net/sourceforge/munin/%{name}-%{version}.tar.gz
Source10:       http://downloads.sourceforge.net/sourceforge/munin/%{name}-%{version}.tar.gz.sha256sum
Source1:        munin-1.2.4-sendmail-config
Source2:        munin-1.2.5-hddtemp_smartctl-config
Source3:        munin-node.logrotate
Source4:        munin.logrotate
Source6:        munin-1.2.6-postfix-config
Source7:        munin-1.4.5-df-config
Source8:        munin-node.service
Source9:        %{name}.conf
Source11:       munin-node.service-privatetmp
# BZ#747663 http://munin-monitoring.org/ticket/1155
Source12:       cpuspeed.in.rev1243
Source13:       linux-init.d_munin-asyncd.in
Source14:       munin-asyncd.service
Source15:       munin-fcgi-html.service
Source16:       munin-fcgi-graph.service
Source17:       munin.cron.d
Source18:       munin-node.rc
Source19:       httpd_munin-cgi.conf
Source20:       Makefile.config-dist
Source21:       nginx_munin.conf
Source22:       munin-fcgi-html.rc
Source23:       munin-fcgi-graph.rc
Source24:       munin-2.0.9-amavis-config

#Patch1:         munin-1.4.6-restorecon.patch
#Patch2:         munin-1.4.2-fontfix.patch
Patch4:         munin-2.0.4-Utils-cluck.patch
Patch5:         acpi-2.0.5.patch
#Patch6:         munin-2.0.7-http_loadtime.patch
#Patch7:         munin-2.0-defect-1213.patch
#Patch8:         munin-2.0.2-defect-1245-LimitsOld.pm-notify_alias.patch
Patch9:         munin-2.0.8-cgitmp.patch
# BZ# 877116 Patch using '&' in the URLs instead of '&amp;' in HTMLConfig
Patch10:        munin-2.0.9_HTMLConfig.pm.patch
Patch11:        https://github.com/munin-monitoring/munin/pull/274.patch
Patch12:        bz1049262-ntp_.patch
Patch13:        mariadb-show-status.patch
Patch14:        mariadb-innodb.patch
Patch15:        munin-2.0.26-406c67e.diff

BuildArch:      noarch

%if 0%{?fedora} > 20
BuildRequires:  /bin/hostname
%else
BuildRequires:  /bin/hostname
%endif
BuildRequires:  perl
%if 0%{?rhel} > 6 || 0%{?fedora} > 12
BuildRequires:  perl(Directory/Scratch.pm)
%endif
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Net/Server.pm)
BuildRequires:  perl(Net/SNMP.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/MockModule.pm)
BuildRequires:  perl(Test/MockObject.pm)
#BuildRequires:  perl(Test::Perl::Critic) >= 1.096 ## Not packaged
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(Net/SSLeay.pm)
BuildRequires:  perl(HTML/Template.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
# Work-around for koji
%if 0%{?rhel} > 6 || 0%{?fedora} > 16
BuildRequires:  perl-base
%endif
# RHEL6+ BuildRequires:  perl(Log::Log4perl) >= 1.18
%if 0%{?rhel} > 5 || 0%{?fedora} > 11
BuildRequires:  perl(Log/Log4perl.pm)
%else
BuildRequires:  perl(Log/Log4perl.pm)
%endif
Requires(pre):  shadow-utils

# Munin server requires
Requires:       logrotate
Requires:       perl
Requires:       perl(CGI/Fast.pm)
Requires:       perl(FCGI.pm)
Requires:       perl(Digest/MD5.pm)
Requires:       perl(File/Copy/Recursive.pm)
Requires:       perl(Getopt/Long.pm)
Requires:       perl(HTML/Template.pm)
Requires:       perl(IO/Socket/INET6.pm)
Requires:       perl(Net/Server.pm)
Requires:       perl(Net/SNMP.pm)
Requires:       perl(Net/SSLeay.pm)
Requires:       perl(Params/Validate.pm)
Requires:       perl(RRDs.pm)
Requires:       perl(Storable.pm)
Requires:       perl(Text/Balanced.pm)
Requires:       perl(DateTime.pm)
Requires:       perl(Time/HiRes.pm)
Requires:       perl(Taint/Runtime.pm)
Requires:       sysstat
Requires:       crontabs
# BZ#913111 : Removed because it pulls boa .. and no clean way to prefer apache.
#Requires:       webserver

# SystemD
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
%endif

# Munin node requires
%if 0%{?rhel} > 6
#Requires:       perl(Cache::Memcached)
#Requires:       perl(Carp::Always)
# This one is in fact optional, only needed for cidr_allow in munin-node,
# which is documented in the manual page. Not present in el7.
#Requires:       perl(Net::CIDR)
%else
Requires:       perl(Cache/Memcached.pm)
Requires:       perl(Carp/Always.pm)
Requires:       perl(Net/CIDR.pm)
%endif
Requires:       perl(Crypt/DES.pm)
Requires:       perl(Digest/HMAC.pm)
Requires:       perl(Digest/SHA1.pm)
Requires:       perl(Net/Server.pm)
Requires:       perl(Net/Server/Fork.pm)
Requires:       perl(Net/SNMP.pm)
Requires:       perl(Net/SSLeay.pm)
Requires:       perl(Time/HiRes.pm)
# mysql plugin requires perl(Cache::Cache)
Requires:       perl(Cache/Cache.pm)

# Munin node java monitor requires
#Requires:       java-jmx # rhel<5
BuildRequires:  java-devel
BuildRequires:  jpackage-utils
%if 0%{?rhel} > 6
# RHEL7 does not have mx4j
#BuildRequires:  mx4j
%else
BuildRequires:  mx4j
%endif
Source44: import.info

# CGI requires
# RHEL6+ Requires:       dejavu-sans-mono-fonts


%description
Munin is a highly flexible and powerful solution used to create graphs
of virtually everything imaginable throughout your network, while still
maintaining a rattling ease of installation and configuration.

This package contains the grapher/gatherer. You will only need one instance of
it in your network. It will periodically poll all the nodes in your network
it's aware of for data, which it in turn will use to create graphs and HTML
pages, suitable for viewing with your graphical web browser of choice.

Munin is written in Perl, and relies heavily on Tobi Oetiker's excellent
RRDtool.

Creaete a munin web user after installing:
htpasswd -bc /etc/munin/munin-htpasswd MUNIN_WEB_USER PASSWORD


%package node
Group:          System/Servers
Summary:        Network-wide graphing framework (node)
BuildArch:      noarch
Requires:       %{name}-common = %{version}
Requires:       perl-Net-Server
Requires:       perl-Net-CIDR
Requires:       procps >= 2.0.7
Requires:       sysstat /usr/bin/which hdparm
Requires:       perl(LWP/UserAgent.pm)
Requires(pre):  shadow-utils
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(preun): /sbin/service

%description node
Munin is a highly flexible and powerful solution used to create graphs
of virtually everything imaginable throughout your network, while still
maintaining a rattling ease of installation and configuration.

This package contains node software. You should install it on all the nodes
in your network. It will know how to extract all sorts of data from the
node it runs on, and will wait for the gatherer to request this data for
further processing.

It includes a range of plugins capable of extracting common values such as
cpu usage, network usage, load average, and so on. Creating your own plugins
which are capable of extracting other system-specific values is very easy,
and is often done in a matter of minutes. You can also create plugins which
relay information from other devices in your network that can't run Munin,
such as a switch or a server running another operating system, by using SNMP
or similar technology.

Munin is written in Perl, and relies heavily on Tobi Oetiker's excellent
RRDtool.

%package async
Group:          System/Servers
Summary:        Network-wide graphing framework (asynchronous client tools)
BuildArch:      noarch
Requires:       %{name}-node = %{version}

%description async
Munin is a highly flexible and powerful solution used to create graphs of
virtually everything imaginable throughout your network, while still
maintaining a rattling ease of installation and configuration.

This package contains the tools necessary for setting up an asynchronous
client / spooling system.

See documentation for setup instructions:
https://munin.readthedocs.org/en/latest/node/async.html


%package common
Group:          System/Servers
Summary:        Network-wide graphing framework (common files)
BuildArch:      noarch
Requires(pre):  shadow-utils

%description common
Munin is a highly flexible and powerful solution used to create graphs
of virtually everything imaginable throughout your network, while still
maintaining a rattling ease of installation and configuration.

This package contains common files that are used by both the server (munin)
and node (munin-node) packages.


%package java-plugins
Group:          System/Servers
Summary:        java-plugins for munin
Requires:       %{name}-node = %{version}
BuildArch:      noarch
Requires:       jpackage-utils

%description java-plugins
java-plugins for munin-node.

Install this sub-package for the jmx node plugin.

%package ruby-plugins
Group:          System/Servers
Summary:        ruby-plugins for munin
Requires:       %{name}-node = %{version}
BuildArch:      noarch

%description ruby-plugins
ruby-plugins for munin-node.

Install this sub-package for the tomcat node plugin.


# BZ# 861816 munin-2.x CGI support is broken without manual hacks
%package cgi
Group:          System/Servers
Summary:        Network-wide graphing framework (cgi files for apache)
BuildArch:      noarch
Requires:       %{name}-common = %{version}
Requires:       mod_fcgid
Requires(pre):  shadow-utils

%description cgi
Munin package uses cron by default.  This package contains the CGI files that
can generate HTML and graphs dynamically. This enables munin to scale better
for a master with many nodes.

See documentation for setup instructions:
http://munin-monitoring.org/wiki/CgiHowto2
http://munin.readthedocs.org/en/latest/example/webserver/apache-virtualhost.html

QUICK-HOWTO:
sed -i 's/\(.*\)_strategy.*/\1_strategy cgi/' /etc/munin/munin.conf
htpasswd -bc /etc/munin/munin-htpasswd MUNIN_WEB_USER PASSWORD
for svc in httpd munin-node ; do
  service $svc stop
  chkconfig $svc on
  service $svc start
done

# BZ# 905241
%package nginx
Group:          System/Servers
Summary:        Network-wide graphing framework (cgi files for nginx)
BuildArch:      noarch
Requires:       %{name}-common = %{version}
Requires:       spawn-fcgi

%description nginx
Munin package uses cron by default.  This package contains the CGI files that
can generate HTML and graphs dynamically. This enables munin to scale better
for a master with many nodes.

QUICK-HOWTO:
sed -i 's/\(.*\)_strategy.*/\1_strategy cgi/;s/#cgiurl_graph/cgiurl_graph/' /etc/munin/munin.conf
for svc in munin-fcgi-graph munin-fcgi-html nginx ; do
  service $svc stop
  chkconfig $svc on
  service $svc start
done

%package netip-plugins
Group:          System/Servers
Summary:        Network-wide graphing framework (dhcpd3 and ntp plugins)
BuildArch:      noarch
Requires:       %{name}-common = %{version}

%description netip-plugins
Munin plugins that require Net::IP.  This is only dhcpd3 and ntp currently.


%prep
%setup -q -n munin-%{version}

%if 0%{?rhel} < 6 && 0%{?fedora} < 11
install -c %{SOURCE12} ./plugins/node.d.linux/cpuspeed.in
%endif

%if 0%{?rhel} > 6
# This one relies on Cache::Memcached, which is not shipped with el7
rm -f plugins/node.d/memcached_.in
%endif

%patch4 -p0
%patch5 -p0
#% patch7 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
install -c %{SOURCE13} ./resources/

# Create Makefile.config-dist
install -c %{SOURCE20} .
sed -i -e 's,^PERLSITELIB := \(.*\),PERLSITELIB := %{perl_vendor_privlib},;' Makefile.config-dist


%build
%if 0%{?rhel} > 6
export  CLASSPATH=plugins/javalib/org/munin/plugin/jmx:$CLASSPATH
%else
export  CLASSPATH=plugins/javalib/org/munin/plugin/jmx:$(build-classpath mx4j):$CLASSPATH
%endif
make    CONFIG=Makefile.config-dist

# Convert to utf-8
for file in Announce-2.0 COPYING ChangeLog Checklist HACKING.pod README RELEASE UPGRADING UPGRADING-1.4; do
    iconv -f ISO-8859-1 -t UTF-8 -o $file.new $file && \
    touch -r $file $file.new && \
    mv $file.new $file
done

# Fix the wrong FSF address
for FILE in plugins/node.d.linux/tcp.in COPYING plugins/node.d.linux/bonding_err_.in; do
  sed -i 's|59 Temple Place.*Suite 330, Boston, MA *02111-1307|51 Franklin St, Fifth Floor, Boston, MA 02110-1301|g' $FILE
done


%install
rm -rf ${buildroot}

## Node
%if 0%{?rhel} > 6
export  CLASSPATH=plugins/javalib/org/munin/plugin/jmx:$CLASSPATH
%else
export  CLASSPATH=plugins/javalib/org/munin/plugin/jmx:$(build-classpath mx4j):$CLASSPATH
%endif
make    CONFIG=Makefile.config-dist \
        DESTDIR=%{buildroot} \
%if 0%{?rhel} > 7 || 0%{?fedora} > 19
        DOCDIR=%{buildroot}%{_docdir}/%{name} \
%else
        DOCDIR=%{buildroot}%{_docdir}/%{name}-%{version} \
%endif
        JAVALIBDIR=%{buildroot}%{_datadir}/java \
        MANDIR=%{buildroot}%{_mandir} \
        PREFIX=%{buildroot}%{_prefix} \
        USER=nobody GROUP=nobody \
        install

# Remove fonts
rm %{buildroot}%{_datadir}/munin/DejaVuSans*.ttf

# install logrotate scripts
mkdir -p %{buildroot}/etc/logrotate.d
install -m 0644 %{SOURCE3} %{buildroot}/etc/logrotate.d/munin-node
install -m 0644 %{SOURCE4} %{buildroot}/etc/logrotate.d/munin

# BZ#821912 - Move .htaccess to apache config to allow easier user-access changes.
mkdir -p %{buildroot}%{_sysconfdir}/httpd/conf.d
sed -e 's/# </</g' %{buildroot}/var/www/html/munin/.htaccess > %{buildroot}%{_sysconfdir}/httpd/conf.d/munin.conf
echo "ScriptAlias /munin-cgi/munin-cgi-graph /var/www/cgi-bin/munin-cgi-graph" >> \
  %{buildroot}%{_sysconfdir}/httpd/conf.d/munin.conf
rm %{buildroot}/var/www/html/munin/.htaccess

# install cron script
mkdir -p %{buildroot}/etc/cron.d
install -m 0644 %{SOURCE17} %{buildroot}/etc/cron.d/munin

# BZ# 908711
mv %{buildroot}/usr/share/munin/munin-asyncd %{buildroot}/usr/sbin/munin-asyncd

# SystemD
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
mkdir -p %{buildroot}/lib/systemd/system
%endif
# Fedora 17 and higer uses privatetmp
%if 0%{?fedora} == 16
install -m 0644 %{SOURCE8} %{buildroot}/lib/systemd/system/munin-node.service
install -m 0644 %{SOURCE14} %{buildroot}/lib/systemd/system/munin-asyncd.service
install -m 0644 %{SOURCE15} %{buildroot}/lib/systemd/system/munin-fcgi-html.service
install -m 0644 %{SOURCE16} %{buildroot}/lib/systemd/system/munin-fcgi-graph.service
%endif
%if 0%{?rhel} > 6 || 0%{?fedora} > 16
install -m 0644 %{SOURCE11} %{buildroot}/lib/systemd/system/munin-node.service
install -m 0644 %{SOURCE14} %{buildroot}/lib/systemd/system/munin-asyncd.service
install -m 0644 %{SOURCE15} %{buildroot}/lib/systemd/system/munin-fcgi-html.service
install -m 0644 %{SOURCE16} %{buildroot}/lib/systemd/system/munin-fcgi-graph.service
%endif
mkdir -p %{buildroot}/var/lib/munin/spool

# install tmpfiles.d entry
%if 0%{?rhel} > 6 || 0%{?fedora} > 14
mkdir -p %{buildroot}%{_sysconfdir}/tmpfiles.d
install -m 0644 %{SOURCE9} %{buildroot}%{_sysconfdir}/tmpfiles.d/%{name}.conf
%endif

# Fedora 15 and rhel use sysvinit / upstart
%if (0%{?rhel} > 4 && 0%{?rhel} <= 6) || 0%{?fedora} == 15
mkdir -p %{buildroot}/etc/rc.d/init.d
cat %{SOURCE18} | sed -e 's/2345/\-/' > %{buildroot}/etc/rc.d/init.d/munin-node
chmod 755 %{buildroot}/etc/rc.d/init.d/munin-node
install -m 0755 %{SOURCE13} %{buildroot}/etc/rc.d/init.d/munin-asyncd
install -m 0755 %{SOURCE22} %{buildroot}/etc/rc.d/init.d/munin-fcgi-html
install -m 0755 %{SOURCE23} %{buildroot}/etc/rc.d/init.d/munin-fcgi-graph
%endif

# Fix default config file
sed -i '
  s,/etc/munin/munin-conf.d,/etc/munin/conf.d,;
  s,#html_strategy.*,html_strategy cron,;
  s,#graph_strategy.*,graph_strategy cron,;
  s,#cgiurl_graph,cgiurl_graph,;
  ' %{buildroot}/etc/munin/munin.conf
mkdir -p %{buildroot}/etc/munin/conf.d
mkdir -p %{buildroot}/etc/munin/plugin-conf.d
mkdir -p %{buildroot}/etc/munin/node.d
mkdir -p %{buildroot}/etc/munin/plugin-node.d

# install config for sendmail under fedora
install -m 0644 %{SOURCE1} %{buildroot}/etc/munin/plugin-conf.d/sendmail

# install config for hddtemp_smartctl
install -m 0644 %{SOURCE2} %{buildroot}/etc/munin/plugin-conf.d/hddtemp_smartctl

# install logrotate scripts
install -m 0644 %{SOURCE3} %{buildroot}/etc/logrotate.d/munin-node
install -m 0644 %{SOURCE4} %{buildroot}/etc/logrotate.d/munin
%if 0%{?fedora} > 15 || 0%{?rhel} > 6
echo 'Using SU directive for logrotate.d'
%else
# Fedora >= 16 requires 'su' directive.
echo 'Commenting out SU directive for logrotate.d'
sed -i 's/su /#su /' %{buildroot}/etc/logrotate.d/munin-node
sed -i 's/su /#su /' %{buildroot}/etc/logrotate.d/munin
%endif

# install config for postfix under fedora
install -m 0644 %{SOURCE6} %{buildroot}/etc/munin/plugin-conf.d/postfix

# install df config to exclude fses we shouldn't try and monitor
install -m 0644 %{SOURCE7} %{buildroot}/etc/munin/plugin-conf.d/df

# Install amavis config file to set MUNIN_MKTEMP env
install -m 0644 %{SOURCE24} %{buildroot}/etc/munin/plugin-conf.d/amavis

# Append for BZ# 746083
cat - >> %{buildroot}/etc/munin/plugin-conf.d/munin-node <<EOT.node
[diskstats]
user munin

[iostat_ios]
user munin
EOT.node

# http://munin-monitoring.org/ticket/808
cat - >> %{buildroot}/etc/munin/plugin-conf.d/fw_ <<EOT.fw
[fw_*]
user root
EOT.fw

# Preload static html files
mkdir -p %{buildroot}/var/www/html/munin/
cp -r %{buildroot}/etc/munin/static %{buildroot}/var/www/html/munin/

# Remove plugins that are missing deps
rm %{buildroot}/usr/share/munin/plugins/sybase_space

# Create DBDIRNODE
mkdir -p %{buildroot}/var/lib/munin-node/plugin-state

# Create for BZ 786030
touch %{buildroot}/var/lib/munin/plugin-state/yum.state

# Create CGI tmpdir space
mkdir -p %{buildroot}/var/lib/munin/cgi-tmp/munin-cgi-graph

# BZ# 881689 - Fix config file so that it no longer references the build host
sed -i 's/^\[.*/\[localhost\]/' %{buildroot}/etc/munin/munin.conf

# BZ# 885422 Move munin-node logs to /var/log/munin-node/
mkdir -p %{buildroot}/var/log/munin-node
sed -i -e '
  s,^log_file .*,log_file /var/log/munin-node/munin-node.log,;
  s,^#host_name .*,host_name localhost.localdomain,;
  ' %{buildroot}/etc/munin/munin-node.conf

# Create sample fcgi config files
mkdir -p %{buildroot}/etc/sysconfig %{buildroot}/etc/httpd/conf.d
cp %{SOURCE19} %{buildroot}/etc/httpd/conf.d/munin-cgi.conf
mkdir -p %{buildroot}/etc/nginx/conf.d
cp %{SOURCE21} %{buildroot}/etc/nginx/conf.d/munin.conf

# Create sample htpasswd file
touch %{buildroot}/etc/munin/munin-htpasswd

# Fix munin-check to report more accurately
sed -i -e '
  s,nobody,munin,;
  s,owner_ok /var/log/munin .*,owner_ok /var/log/munin apache,;
  s,owner_ok /var/lib/munin .*,owner_ok /var/lib/munin munin,;
  s,owner_ok /var/lib/munin/plugin-state .*,owner_ok /var/lib/munin/plugin-state root,;
  ' %{buildroot}/usr/bin/munin-check


%pre common
/usr/bin/getent group munin >/dev/null || \
  /usr/sbin/groupadd -r munin
/usr/bin/getent passwd munin >/dev/null || \
  /usr/sbin/useradd -r -g munin -d /var/lib/munin -s /sbin/nologin \
    -c "Munin user" munin
exit 0

%pre node
/usr/bin/getent group munin >/dev/null || \
  /usr/sbin/groupadd -r munin
/usr/bin/getent passwd munin >/dev/null || \
  /usr/sbin/useradd -r -g munin -d /var/lib/munin -s /sbin/nologin \
    -c "Munin user" munin
exit 0

%pre cgi
chown apache /var/log/munin
exit 0

%post node
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
  %if 0%{?systemd_post:1}
%post_service munin-node
  %else
  %endif
%else
  # sysvinit only in f15 and older and epel
  /sbin/chkconfig --add munin-node
%endif
# Only run configure on a new install, not an upgrade.
if [ "$1" = "1" ]; then
     /usr/sbin/munin-node-configure --shell 2> /dev/null | sh >& /dev/null || :
fi

%post async
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
  %if 0%{?systemd_post:1}
%post_service munin-asyncd
  %else
  %endif
%else
  # sysvinit only in f15 and older and epel
  /sbin/chkconfig --add munin-asyncd
%endif

%preun node
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
# Newer installs use systemd
  %if 0%{?systemd_preun:1}
%preun_service munin-node
  %else
  %endif
%else
# Older installs use sysvinit / upstart
if [ "$1" = 0 ]; then
  service munin-node stop &>/dev/null || :
  /sbin/chkconfig --del munin-node
fi
%endif

%preun nginx
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
# Newer installs use systemd
  %if 0%{?systemd_preun:1}
    for svc in fcgi-html fcgi-graph ; do
%preun_service munin-${svc}
    done
  %else
  %endif
%else
# Older installs use sysvinit / upstart
if [ "$1" = 0 ]; then
  for svc in fcgi-html fcgi-graph; do
    service munin-${svc} stop &>/dev/null || :
    /sbin/chkconfig --del munin-${svc}
  done
fi
%endif

%postun node
if [ "$1" = "0" ]; then
  [ -d %{_sysconfdir}/munin/plugins ] && \
    find %{_sysconfdir}/munin/plugins/ -maxdepth 1 -type l -print0 | \
      xargs -0 rm || :
fi

%triggerun node -- munin-node < 1.4.7-2
mv -f %{_sysconfdir}/munin/plugins %{_sysconfdir}/munin/plugins.bak || :

%triggerpostun node -- munin-node < 1.4.7-2
mv -f %{_sysconfdir}/munin/plugins.bak %{_sysconfdir}/munin/plugins || :


#
# main package scripts
#
%pre
/usr/bin/getent group munin >/dev/null || \
  /usr/sbin/groupadd -r munin
/usr/bin/getent passwd munin >/dev/null || \
  /usr/sbin/useradd -r -g munin -d /var/lib/munin -s /sbin/nologin \
    -c "Munin user" munin
exit 0


%files
%doc %{_mandir}/man1/munindoc*
%doc %{_mandir}/man1/munin-sched*
%doc %{_mandir}/man3/Munin::Master*
%doc %{_mandir}/man5/munin.conf*
%doc %{_mandir}/man8/munin*
%dir %{_sysconfdir}/munin
%dir %{_sysconfdir}/munin/conf.d
%dir %{_sysconfdir}/munin/static
%dir %{_sysconfdir}/munin/templates
%dir %{_sysconfdir}/munin/templates/partial
%dir %{_datadir}/munin
%dir %{_datadir}/munin/plugins
#BUG. User apache does not necessarily exists when installing package munin
#since httpd is not required. it matters if httpd is later installed and
#the munin graph or html cgi programs are used - they log here.
#this is fixed with %%pre cgi, but if user tries to use the cgi programs
#without the cgi package, it's tough luck.
#proper fix may be to create the apache user in pre, but I'm not gonna do it.
%dir %attr(0775,apache,munin) /var/log/munin
%dir %attr(0775,root,munin) /var/lib/munin/plugin-state
%attr(0755,munin,munin) %dir /var/www/html/munin
%attr(0755,munin,munin) %dir /var/www/html/munin/static
%attr(0755,root,munin) /var/www/cgi-bin/munin-cgi-graph
%attr(0755,root,munin) /var/www/cgi-bin/munin-cgi-html
%attr(0644,munin,munin) /var/www/html/munin/static/*
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/cron.d/munin
%config(noreplace) %{_sysconfdir}/httpd/conf.d/munin.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/munin
%config(noreplace) %{_sysconfdir}/munin/munin.conf
%config(noreplace) %{_sysconfdir}/munin/munin-htpasswd
%config(noreplace) %{_sysconfdir}/munin/static/*
%config(noreplace) %{_sysconfdir}/munin/templates/partial/*.tmpl
%config(noreplace) %{_sysconfdir}/munin/templates/*.tmpl
%attr(0755,root,root) %{_bindir}/munin-check
%attr(0755,root,root) %{_bindir}/munin-cron
%attr(0755,root,root) %{_bindir}/munindoc
%attr(0755,root,root) %{_sbindir}/munin-sched
%{_datadir}/munin/munin-datafile2storable
%{_datadir}/munin/munin-graph
%{_datadir}/munin/munin-html
%{_datadir}/munin/munin-limits
%{_datadir}/munin/munin-storable2datafile
%{_datadir}/munin/munin-update
%{perl_vendor_privlib}/Munin/Master/*.pm


%files node
%doc %{_mandir}/man1/munin-node*
%doc %{_mandir}/man1/munin-run*
%doc %{_mandir}/man3/Munin::Common*
%doc %{_mandir}/man3/Munin::Node*
%doc %{_mandir}/man3/Munin::Plugin*
%doc %{_mandir}/man5/munin-node*
%dir %{_sysconfdir}/munin/node.d
%dir %{_sysconfdir}/munin/plugins
%dir %{_sysconfdir}/munin
%dir %{_datadir}/munin
%dir %attr(-,munin,munin) /var/lib/munin
%dir %attr(0775,nobody,munin) /var/lib/munin-node/plugin-state
%dir %attr(0755,root,root) /var/log/munin-node
%config(noreplace) %{_sysconfdir}/logrotate.d/munin-node
%config(noreplace) %{_sysconfdir}/munin/munin-node.conf
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/amavis
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/df
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/fw_
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/hddtemp_smartctl
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/munin-node
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/postfix
%config(noreplace) %{_sysconfdir}/munin/plugin-conf.d/sendmail
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
/lib/systemd/system/munin-node.service
%else
%{_sysconfdir}/rc.d/init.d/munin-node
%endif
%attr(0755,root,root) %{_sbindir}/munin-run
%attr(0755,root,root) %{_sbindir}/munin-node
%attr(0755,root,root) %{_sbindir}/munin-node-configure
%attr(-,munin,munin) /var/lib/munin/plugin-state/yum.state
%exclude %{_datadir}/munin/plugins/dhcpd3
%exclude %{_datadir}/munin/plugins/jmx_
%exclude %{_datadir}/munin/plugins/ntp_
%exclude %{_datadir}/munin/plugins/tomcat_
%{_datadir}/munin/plugins/
%{perl_vendor_privlib}/Munin/Node
%{perl_vendor_privlib}/Munin/Plugin*
# sisyphus_check: check-subdirs ERROR: subdirectories packaging violation
%dir %attr(0775,root,munin) /var/lib/munin/plugin-state
%dir %{_sysconfdir}/munin/plugin-conf.d


%files async
%{_sbindir}/munin-asyncd
%{_datadir}/munin/munin-async
%dir /var/lib/munin/spool
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
/lib/systemd/system/munin-asyncd.service
%else
%{_sysconfdir}/rc.d/init.d/munin-asyncd
%endif


%files common
%doc Announce-2.0 COPYING ChangeLog Checklist HACKING.pod README RELEASE UPGRADING UPGRADING-1.4
%dir %{perl_vendor_privlib}/Munin
%dir %attr(-,munin,munin) %{_var}/run/%{name}/
%if 0%{?rhel} > 6 || 0%{?fedora} > 14
%config(noreplace) %{_sysconfdir}/tmpfiles.d/%{name}.conf
%endif
%{perl_vendor_privlib}/Munin/Common


%files java-plugins
%{_datadir}/java/munin-jmx-plugins.jar
%{_datadir}/munin/plugins/jmx_


%files ruby-plugins
%{_datadir}/munin/plugins/tomcat_


%files cgi
%config(noreplace) %{_sysconfdir}/httpd/conf.d/munin-cgi.conf
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
/lib/systemd/system/munin-fcgi-html.service
/lib/systemd/system/munin-fcgi-graph.service
%endif
%attr(0755,root,root) %dir /var/lib/munin/cgi-tmp
%attr(0755,apache,apache) %dir /var/lib/munin/cgi-tmp/munin-cgi-graph


%files nginx
%config(noreplace) %{_sysconfdir}/nginx/conf.d/munin.conf
%if 0%{?rhel} > 6 || 0%{?fedora} > 15
/lib/systemd/system/munin-fcgi-html.service
/lib/systemd/system/munin-fcgi-graph.service
%else
%{_sysconfdir}/rc.d/init.d/munin-fcgi-html
%{_sysconfdir}/rc.d/init.d/munin-fcgi-graph
%endif


%files netip-plugins
%{_datadir}/munin/plugins/dhcpd3
%{_datadir}/munin/plugins/ntp_


%changelog
