Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/egrep /usr/bin/groff /usr/bin/pamtowinicon /usr/bin/ppmtogif /usr/bin/ppmtopgm /usr/bin/ppmtowinicon /usr/bin/xpmtoppm groff-ps libX11-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name mup
%define version 7.0
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Name:           mup
Version:        7.0

Release:        alt1_5
Summary:        A music notation program that can also generate MIDI files
License:        Mup
URL:            http://www.arkkra.com/doc/overview.html

%define         versionnodot %(echo %{version} | tr -d ".")

Source0:        http://www.arkkra.com/ftp/pub/unix/mup%{versionnodot}src.tar.gz
Source1:        mupmate.desktop

# Newer Fedora build roots no longer include, gcc, gcc-c++ by default
# https://fedoraproject.org/wiki/Packaging:C_and_C%2B%2B
BuildRequires:  gcc
BuildRequires:  gcc-c++

BuildRequires:  glibc-devel glibc-devel-static
BuildRequires:  libfltk-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  zlib-devel
BuildRequires:  libXinerama-devel
BuildRequires:  libXext-devel
BuildRequires:  libXpm libXpm-devel
BuildRequires:  libXft-devel
BuildRequires:  desktop-file-utils
BuildRequires:  bison
BuildRequires:  flex
BuildRequires:  man-db
Source44: import.info

%description
Mup is a program for printing music. It takes an input file containing ordinary
(ASCII) text describing music, and produces PostScript output for printing the
musical score described by the input.

%prep
%setup -q

# Preserve the timestamp of files that we copy from the Mup source tree
sed -i -e 's|cp |cp -p |' simple.makefile

%build
%make_build CFLAGS="%{optflags}" CXXFLAGS="%{optflags}" LIBDIR="%{_datadir}/%{name}" DOCDIR="%{_docdir}/%{name}" -f simple.makefile

%install
make DESTDIR="%{buildroot}" LIBDIR="%{buildroot}%{_datadir}/%{name}" DOCDIR="%{buildroot}%{_docdir}/%{name}" install -f simple.makefile

# License is handled separately
rm "%{buildroot}%{_docdir}/%{name}/license.txt"

# Add docs that aren't installed by make install
cp -a AUTHORS ChangeLog NEWS README "%{buildroot}%{_docdir}/%{name}"/.

# Remove docs that are not applicable
rm "%{buildroot}%{_docdir}/%{name}/Macinst.html"
rm "%{buildroot}%{_docdir}/%{name}/winrun.html"

mkdir -p %{buildroot}/%{_datadir}/applications
cp -p %{SOURCE1} %{buildroot}/%{_datadir}/applications/
desktop-file-validate %{buildroot}/%{_datadir}/applications/mupmate.desktop

%files
%doc --no-dereference LICENSE
%{_docdir}/%{name}/*
%{_bindir}/*
%{_mandir}/man1/*
%{_datadir}/mup
%{_datadir}/applications/*
%{_datadir}/pixmaps/*

%changelog
