%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: Development/C
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nacl
# http://nacl.cr.yp.to/
URL:            http://nacl.cace-project.eu/
Version:        20110221
Release:        alt2_26
License:        Public Domain
Summary:        Networking and Cryptography library

Source0:        http://hyperelliptic.org/nacl/nacl-%{version}.tar.bz2
Source1:        curvecpclient.1
Source2:        curvecpserver.1
Source3:        curvecpmakekey.1
Source4:        curvecpmessage.1
Source5:        curvecpprintkey.1
Source6:        nacl-sha256.1
Source7:        nacl-sha512.1
Patch0:         nacl-20110221-dist-flags.patch
Patch1:         nacl-20110221-build-dir.patch
Patch2:         nacl-20110221-noexec-stack.patch
# Fix for secondary arches
Patch3:         nacl-20110221-cpufreq-fallback.patch
Patch4:         nacl-20110221-abi-len-limit.patch

BuildRequires:  gcc
BuildRequires:  e2fsprogs
Source44: import.info

%description
NaCl (pronounced "salt") is a new easy-to-use high-speed software library for
network communication, encryption, decryption, signatures, etc. NaCl's goal
is to provide all of the core operations needed to build higher-level
cryptographic tools.

%package devel
Group: Development/C
Summary:        Development files
Requires:       %{name} = %{version}-%{release}

%description devel
Include files and devel library.

%package static
Group: Development/C
Summary:        Static version of the NaCl library
Provides:       nacl-static = %{version}-%{release}

%description static
Statically linkable version of the NaCl library.

%prep
%setup -q
%patch0 -p1 -b .dist-flags
%patch1 -p1 -b .build-dir
%patch2 -p1 -b .noexec-stack
%patch3 -p1 -b .cpufreq-fallback
%patch4 -p1 -b .abi-len-limit

sed -i 's|\${CFLAGS}|%{optflags} -fPIC|g' okcompilers/c okcompilers/cpp

%build
./do
# shared library
g++ -shared -fPIC -Wl,-soname,libnacl.so.0 -o libnacl.so.0.0.0 \
  -Wl,-whole-archive build/fedora/lib/*/libnacl.a -Wl,-no-whole-archive \
  build/fedora/lib/*/cpucycles.o build/fedora/lib/*/randombytes.o

%install
mkdir -p %{buildroot}%{_includedir}/%{name}
install -m 0644 -t %{buildroot}%{_includedir}/%{name} build/fedora/include/*/*.h
mkdir -p %{buildroot}%{_libdir}/
install -m 0644 -t %{buildroot}%{_libdir} build/fedora/lib/*/*.a

# install cpucycles.o and randombytes.o
install -m 0644 -t %{buildroot}%{_libdir} build/fedora/lib/*/cpucycles.o build/fedora/lib/*/randombytes.o

# install shared library
install -m 0755 -t %{buildroot}%{_libdir} libnacl.so.*
pushd %{buildroot}%{_libdir}
ln -s libnacl.so.0.0.0 libnacl.so.0
ln -s libnacl.so.0 libnacl.so
popd

mkdir -p %{buildroot}%{_mandir}/man1
install -m 0644 -t %{buildroot}%{_mandir}/man1 %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} %{SOURCE5} %{SOURCE6} %{SOURCE7}
mkdir -p %{buildroot}%{_bindir}
rm -f build/fedora/bin/ok*
install -m 0755 -t %{buildroot}%{_bindir} build/fedora/bin/*

%files
%{_libdir}/libnacl.so.*
%{_bindir}/*
%{_mandir}/man1/*

%files static
%{_libdir}/libnacl.a
%{_libdir}/cpucycles.o
%{_libdir}/randombytes.o

%files devel
%{_libdir}/libnacl.so
%{_includedir}/nacl

%changelog
