# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/doxygen /usr/bin/git /usr/bin/itstool binutils-devel pkgconfig(luajit)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define rdnsname org.naev.naev

Name:           naev
Version:        0.8.1
Release:        alt1_4
Summary:        2D space trading and combat game
Group:          Games/Other
License:        GPLv3+
URL:            https://naev.org
Source0:        https://github.com/naev/naev/releases/download/v%{version}/%{name}-%{version}-source.tar.gz
Patch0:         naev-0.8.1-system-cxsparse.patch

BuildRequires:  autoconf-archive
BuildRequires:  intltool
BuildRequires:  lua5.1-devel
BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(glu)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(libzip)
BuildRequires:  pkgconfig(openal)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  libsuitesparse-devel

Requires:       %{name} = %{version}-%{release}
Source44: import.info

%description
NAEV is a 2D space trading and combat game, taking inspiration from the
Escape Velocity series, among others.

You pilot a space ship from a top-down perspective, and are more or less
free to do what you want. As the genre name implies, youa.'re able to trade
and engage in combat at will. Beyond that, therea.'s an ever-growing number
of storyline missions, equipment, and ships; even the galaxy itself grows
larger with each release. For the literarily-inclined, there are large
amounts of lore accompanying everything from planets to equipment.

%package data
Group: Games/Other
Summary:        Arch-independent data files for NAEV
BuildArch:      noarch

# Previously packaged in a separate SRPM.
# conflicting files
# /usr/share/games/naev/naev-confupdate.sh moved from naev to naev-data
Conflicts:      naev < 0.7.0-6

%description data
Arch-independent data files for NAEV.

%prep
%setup -q
%patch0 -p1


%build
autoreconf -vfi
%configure \
    --bindir=%{_gamesbindir} \
    --datadir=%{_gamesdatadir} \
    --enable-lua=shared \
    --enable-debug=no
%make_build

%install
%makeinstall_std

# Broken handling of datadir vs datarootdir.
mv %{buildroot}%{_gamesdatadir}/{applications,icons,metainfo} \
    %{buildroot}%{_datadir}/

%find_lang %{name}_src

%files -f %{name}_src.lang
%doc LICENSE README TODO
%{_datadir}/applications/%{rdnsname}.desktop
%{_datadir}/metainfo/%{rdnsname}.metainfo.xml
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/256x256/apps/%{name}.png
%{_mandir}/man6/%{name}.6*

%files data
%{_gamesdatadir}/%{name}/


%changelog
