Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global nagios_plugins_dir %{_libdir}/nagios/plugins

Name:           nagios-plugins-snmp-disk-proc
Version:        1.3.1
Release:        alt2_21
Summary:        Nagios SNMP plugins to monitor remote disk and processes
# Version intent from README
License:        GPLv2
URL:            https://github.com/glensc/nagios-snmp-plugins/
Source0:        https://github.com/glensc/nagios-snmp-plugins/releases/download/%{version}/nagios-snmp-plugins-%{version}.tar.gz
BuildRequires:  gcc
BuildRequires:  autoconf, automake
BuildRequires:  libnet-snmp-devel
BuildRequires:  libssl-devel
# BuildRequires:  tcp_wrappers-devel
Requires:       nagios-plugins-common
Provides:	nagios-snmp-plugins = %{version}-%{release}
Source44: import.info

%description
These plugins allow you to monitor disk space and running processes on
a remote machine via SNMP.

%prep
%setup -q -n nagios-snmp-plugins-%{version}

%build
touch ChangeLog
aclocal
autoheader
automake --add-missing
autoconf
%configure
%make_build

%install
install -d -m 755 $RPM_BUILD_ROOT/%{nagios_plugins_dir}
install -p -m 755 check_snmp_disk $RPM_BUILD_ROOT/%{nagios_plugins_dir}
install -p -m 755 check_snmp_proc $RPM_BUILD_ROOT/%{nagios_plugins_dir}

%files
%doc README COPYING AUTHORS NEWS
%{nagios_plugins_dir}/check_snmp_disk
%{nagios_plugins_dir}/check_snmp_proc

%changelog
