Group: Communications
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nec2c
Version:        1.3
Release:        alt1_21
Summary:        Translation of NEC2 antenna modeling tool from FORTRAN to C

License:        Public Domain
URL:            http://5b4az.chronos.org.uk/pages/nec2.html
Source0:        http://5b4az.chronos.org.uk/pkg/nec2/nec2c/%{name}-%{version}.tar.bz2
Source1:        nec2c.1

BuildRequires:  gcc
# Should not be required but configure checks for it.
BuildRequires:  gcc-c++
%if ! 0%{?rhel}
BuildRequires:  help2man
%endif
Source44: import.info

%description
nec2c is a translation of the Numerical Electromagnetics Code (NEC2)
from FORTRAN to C. 

Operationally nec2c differs from NEC2 by being a command line
non-interactive program, taking as arguments the input file name
and optionally the output file name.


%prep
%setup -q



%build
%configure
%make_install CFLAGS="%{optflags}"


%install
#skip make install and do manual install, it's just one file
install -D -m 0755 nec2c %{buildroot}%{_bindir}/nec2c

mkdir -p %{buildroot}%{_mandir}/man1
%if 0%{?rhel}
    install -pm 0644 %{SOURCE1} %{buildroot}%{_mandir}/man1
%else
    help2man -o %{buildroot}%{_mandir}/man1/%{name}.1 -h -h -v -v --no-discard-stderr -N %{buildroot}%{_bindir}/%{name}
%endif


%files
%doc AUTHORS README NEC2-bug.txt
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*


%changelog
