Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:       Acid sounds synthesizer
Name:          nekobee-dssi
Version:       0.1.7
Release:       alt2_24
License:       GPLv2+
URL:           http://www.nekosynth.co.uk/wiki/nekobee
Source0:       http://www.nekosynth.co.uk/releases/nekobee-%{version}.tar.gz
Source1:       nekobee.desktop
# Derived from extra/knob.png
Source2:       nekobee.png
Patch0:        nekobee-gcc10.patch

BuildRequires: libalsa-devel
BuildRequires: desktop-file-utils
BuildRequires: dssi-devel
BuildRequires: gcc
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel libgtk+2-gir-devel
BuildRequires: liblo-devel

Requires:      dssi
Source44: import.info

%description
Since it was first released in 2004, the Disposable Soft Synth Interface has
allowed Linux audio users to have simple plugin software synthesizers. Over
time, the number of these has grown as users and coders have developed new
plugins for particular sounds. Now, nekosynth brings some new plugins to enrich
your sonic palette.

This package provides the nekobee DSSI plugin, which is suitable for recreating
those squelchy acid sounds.

%prep
%setup -q -n nekobee-%{version}
%patch0 -p1 -b .gcc10

%build
%configure
%make_build

%install
make install DESTDIR="$RPM_BUILD_ROOT" INSTALL="install -p"

# Make a symlink for easy access
mkdir -p $RPM_BUILD_ROOT%{_bindir}
ln -s jack-dssi-host $RPM_BUILD_ROOT%{_bindir}/nekobee

# Kill .la file
rm $RPM_BUILD_ROOT%{_libdir}/dssi/nekobee.la

# Kill zero-length file
rm $RPM_BUILD_ROOT%{_libdir}/dssi/nekobee/switch.png

# Desktop file
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install                              \
  --dir ${RPM_BUILD_ROOT}%{_datadir}/applications \
  %{SOURCE1}

# Icon
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps
install -pm 644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps/nekobee.png

%files
%doc ChangeLog README
%doc --no-dereference COPYING
%{_bindir}/nekobee
%{_libdir}/dssi/nekobee/
%{_libdir}/dssi/nekobee.so
%{_datadir}/applications/nekobee.desktop
%{_datadir}/icons/hicolor/48x48/apps/nekobee.png

%changelog
