Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           netstat-monitor
Version:        1.1.3
Release:        alt2_27
Summary:        A command line tool to monitor network connections

License:        AGPLv3+
URL:            https://github.com/stalexan/netstat-monitor
Source0:        https://www.alexan.org/netstat-monitor/%{name}-%{version}.tar.gz
# Use ipaddress module (from Python 3 stdlib), not non-Python-3 compatible
# ipaddr (which ipaddress is a fork of in any case)
# https://github.com/stalexan/netstat-monitor/pull/15 , rediffed
Patch0:         netstat-monitor-1.1.3-ipaddress.patch
# Make test runner exit 1 if tests fail (not 0)
Patch1:         https://github.com/stalexan/netstat-monitor/pull/16.patch
BuildArch:      noarch

BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  python3-module-netaddr

Requires:       python3-module-netaddr
Source44: import.info

%description
Netstat-monitor is a command line tool for monitoring network connections.
Its output is similar to the output from the netstat command with the options
"netstat --inet -alp". Netstat-monitor can be left running, though, and will
report new connections as they are made. Also, filters can be used to limit
what's displayed to just what's unexpected or interesting.

%prep
%setup -q
%patch0 -p1
%patch1 -p1

sed -i -e '/^#!\//, 1d' netstat.py

%build
%python3_build

%install
%python3_install
mkdir -p %{buildroot}%{_datadir}/%{name}
mv %{buildroot}/usr/sample-filters \
    %{buildroot}%{_datadir}/%{name}/sample-filters

%check
PYTHONPATH=./ %{__python3} test/test-netstat

%files
%doc README.md
%doc --no-dereference LICENSE 
%{_bindir}/%{name}
%{python3_sitelibdir_noarch}/*
%{_datadir}/%{name}/sample-filters
%{python3_sitelibdir_noarch}/__pycache__/*

%changelog
