Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nfoview
Version:        1.28.1
Release:        alt1_9
Summary:        Viewer for NFO files

License:        GPLv3+
URL:            https://otsaloma.io/nfoview/
Source0:        https://github.com/otsaloma/nfoview/archive/%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  python3-module-pygobject3-devel

BuildRequires:  desktop-file-utils
BuildRequires:  intltool
BuildRequires:  libappstream-glib libappstream-glib-gir

Requires:       shared-mime-info
Requires:       icon-theme-hicolor
Requires:       python3-module-pygobject3
Requires:       fonts-bitmap-terminus
Source44: import.info

%description
NFO Viewer is a simple viewer for NFO files, which are "ASCII" art in
the CP437 codepage. The advantages of using NFO Viewer instead of a
text editor are preset font and encoding settings, automatic window
size and clickable hyperlinks.

%prep
%setup -q


%build
%python3_build

%install
%python3_install
desktop-file-install                                        \
    --add-category="TextTools;"                             \
    --remove-category="Viewer;"                             \
    --delete-original                                       \
    --dir=%{buildroot}%{_datadir}/applications              \
    %{buildroot}%{_datadir}/applications/io.otsaloma.nfoview.desktop
%find_lang %{name}

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/io.otsaloma.nfoview.appdata.xml

%files -f %{name}.lang
%doc AUTHORS.md NEWS.md README.md
%doc --no-dereference COPYING
%{_mandir}/man*/%{name}.*
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_metainfodir}/io.otsaloma.nfoview.appdata.xml
%{python3_sitelibdir_noarch}/%{name}/
%{python3_sitelibdir_noarch}/%{name}*.egg-info
%{_datadir}/applications/io.otsaloma.nfoview.desktop
%{_datadir}/icons/hicolor/*/apps/io.otsaloma.nfoview*

%changelog
