Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nmbscan
Version:        1.2.6
Release:        alt2_28
Summary:        NMB/SMB network scanner

License:        GPLv2
URL:            http://nmbscan.g76r.eu/
Source0:        http://nmbscan.g76r.eu/down/%{name}-%{version}.tar.gz
Source1:        %{name}.1
#Remove dependency on deprecated arp tool, use ip neigh instead
Patch0:         %{name}-1.2.6-arp.patch

BuildArch:      noarch

Requires:       bind bind-utils
Requires:       iputils
Requires:       arpd iproute2
Requires:       samba-client
Source44: import.info

%description
Scans a SMB shares network, using NMB and SMB protocols. Useful to acquire
an information on a local area network (security audit, etc.)

Matches the information such as NMB/SMB/Windows host name, IP address,
IP host name, Ethernet MAC address, Windows user name,
NMB/SMB/Windows domain name and master browser.

Can discover all NMB/SMB/Windows hosts on a local area network thanks to 
hosts lists maintained by master browsers.

%prep
%setup -q -c %{name}-%{version}
%patch0 -p 1 -b .arp

%build
# Nothing to build

%install
install -d %{buildroot}%{_bindir}
install -p -m 0755 nmbscan %{buildroot}%{_bindir}/
install -d %{buildroot}%{_mandir}/man1
install -p -m 0644 %{SOURCE1} %{buildroot}%{_mandir}/man1/

%files
%doc Documentation/HOWTO_contribute.txt
%doc --no-dereference Documentation/gplv2.txt
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
