Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-JSV
Version:        4.0.2
Release:        alt1_16
Summary:        JSON Schema Validator

# License text is in lib/jsv.js
License:        BSD
URL:            https://github.com/garycourt/JSV
Source0:        http://registry.npmjs.org/JSV/-/JSV-%{version}.tgz
# Use external uri-js instead of bundled version
Patch0:         nodejs-JSV-uri-js.patch
BuildArch:      noarch

BuildRequires:  node-devel rpm-build-nodejs

BuildRequires:  npm(uri-js)
Source44: import.info

%description
JSV is a JavaScript implementation of a extendable, fully compliant
JSON Schema validator with the following features:

* The fastest extendable JSON validator available!
* Complete implementation of all current JSON Schema draft revisions.
* Supports creating individual environments (sandboxes) that validate
  using a particular schema specification.
* Provides an intuitive API for creating new validating schema
  attributes, or whole new custom schema schemas.
* Supports self, full and described by hyper links.
* Validates itself, and is bootstrapped from the JSON Schema schemas.
* Includes over 1100 unit tests for testing all parts of the specifications.
* Works in all ECMAScript 3 environments, including all web browsers
  and Node.js.
* Licensed under the FreeBSD License, a very open license.


%prep
%setup -q -n package
sed -i -e 's/\r//' package.json lib/*.js README.md CHANGELOG.md
%patch0 -p1
rm -rf node_modules lib/uri


%build


%check
# Tests are only runnable in a web browser at present
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/JSV
cp -pr package.json lib %{buildroot}/%{nodejs_sitelib}/JSV
%nodejs_symlink_deps


%files
%doc README.md CHANGELOG.md docs examples
%{nodejs_sitelib}/JSV


%changelog
