Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global shortname acorn

# We'll temporarily bootstrap with pre-compiled versions in order to build
# newer version of npm(rollup-plugin-buble), then re-build from source with
# the help of npm(buble) and npm(rollup-plugin-buble).
%global bootstrap 1

# Tests
%global enable_tests 1

Name:           nodejs-%{shortname}
Version:        5.2.1
Release:        alt1_6
Summary:        ECMAScript parser

License:        MIT
URL:            https://github.com/ternjs/acorn
Source0:        http://registry.npmjs.org/%{shortname}/-/%{shortname}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:        rollup-%{version}.tar.bz2
Source2:        tests-%{version}.tar.bz2
Source10:       dl-tests.sh

BuildArch:      noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(rollup)
Source44: import.info

%description
A tiny, fast JavaScript parser, written completely in JavaScript.

%prep
%setup -qn package
# setup the files for rollup
%setup -q -T -D -a 1 -n package
# setup the tests
%setup -q -T -D -a 2 -n package

# fix script interpreter
sed -i '1s/env //' bin/acorn

# remove zero-length file
rm dist/.keep


%build
%if 0%{?bootstrap}
# nothing
%else
%{_bindir}/rollup -c rollup/config.main.js
%{_bindir}/rollup -c rollup/config.walk.js
%{_bindir}/rollup -c rollup/config.loose.js
%{_bindir}/rollup -c rollup/config.bin.js
%endif


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{shortname}/
cp -pr package.json bin/ dist/ \
    %{buildroot}%{nodejs_sitelib}/%{shortname}

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/${shortname}/bin/acorn \
    %{buildroot}%{_bindir}/${shortname}

%nodejs_symlink_deps

rm %{buildroot}/usr/bin/acorn
ln -s /usr/lib/node_modules/acorn/bin/acorn %{buildroot}/usr/bin/acorn

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%__nodejs test/run.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE
%doc README.md
%{nodejs_sitelib}/%{shortname}
%{_bindir}/%{shortname}


%changelog
