Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# npm(chai) not yet available on EL6.
%if 0%{?fedora}
%global enable_tests 1
%else
%global enable_tests 0
%endif

Name:       nodejs-ain2
Version:    1.3.2
Release:    alt1_11
Summary:    A Node.js module for syslog logging (and a continuation of ain)
License:    MIT
URL:        https://github.com/phuesler/ain
Source0:    http://registry.npmjs.org/ain2/-/ain2-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(chai)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
This module provides syslog logging for Node.js.

Ain2 is written with full compatibility with the Node.js console module.
It implements all console functions and formatting. Ain2 also supports UTF-8.

Ain2 can send messages by UDP to 127.0.0.1:514 or to the a Unix socket such
as /dev/log.


%prep
%setup -q -n package
for i in CHANGELOG.md LICENSE readme.md; do
    sed 's/\r//' "${i}" > "${i}.new"
    touch -r "${i}" "${i}.new"
    mv "${i}.new" "${i}"
done


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ain2
cp -pr package.json index.js %{buildroot}%{nodejs_sitelib}/ain2

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
# Optional dependency npm(unix-dgram) not yet packaged for Fedora, so disable
# the test.
rm -f test/unix.spec.js
/usr/bin/mocha test/**/*.spec.js
%endif


%files
%doc CHANGELOG.md LICENSE readme.md
%{nodejs_sitelib}/ain2


%changelog
