Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-argparse
Version:    1.0.9
Release:    alt1_8
Summary:    A native port of Python's argparse, an options parsing library
License:    MIT
URL:        https://github.com/nodeca/argparse
Source0:    http://registry.npmjs.org/argparse/-/argparse-%{version}.tgz
# The test/ directory is not included in the npm tarball.
# Source{1,2} is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    examples-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(underscore)
BuildRequires:  npm(underscore.string)
BuildRequires:  npm(sprintf-js)
%endif
Source44: import.info

%description
This is a native port of Python's argparse, an options parsing library.
It's a full port, except some very rare options. Method names have been
changed to CamelCase.


%prep
%setup -q -n package
%setup -q -D -T -a 1 -n package
%setup -q -D -T -a 2 -n package

%nodejs_fixdep sprintf-js '1.x'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/argparse
cp -pr package.json *.js lib/ \
    %{buildroot}%{nodejs_sitelib}/argparse

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%{nodejs_sitelib}/mocha/bin/mocha -R spec
%endif


%files
%doc CHANGELOG.md README.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/argparse


%changelog
