Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 1

%global barename base64-js

Name:               nodejs-base64-js
Version:            1.0.2
Release:            alt1_7
Summary:            Base64 encoding/decoding in pure JS

License:            MIT
URL:                https://www.npmjs.org/package/base64-js
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif


BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(tape)
%endif
Source44: import.info


%description
base64-js does basic base64 encoding/decoding in pure JS.

Many browsers already have base64 encoding/decoding functionality, but it is
for text data, not all-purpose binary data.  Sometimes encoding/decoding binary
data in the browser is useful, and that is what this module does.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/base64-js
cp -pr package.json lib \
    %{buildroot}%{nodejs_sitelib}/base64-js

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
tape test/*.js
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md
%doc --no-dereference LICENSE.MIT
%{nodejs_sitelib}/base64-js/

%changelog
