Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-batch
Version:    0.5.0
Release:    alt1_12
Summary:    Asynchronous batch module with concurrency control and progress reporting
License:    MIT
URL:        https://github.com/visionmedia/batch
Source0:    http://registry.npmjs.org/batch/-/batch-%{version}.tgz
# The test/ and examples/ folders are not included in the npm tarball.
# Source1 and Source2 are generated by running Source10, which pulls from the
# upstream version control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    examples-%{version}.tar.bz2
Source10:   dl-tests.sh

# Fix missing semicolon.
# https://github.com/visionmedia/batch/commit/8a12ad8d352336cd1ab58785e490c3d8ae129a47
Patch0:     %{name}-0.5.0-Fix-missing-semicolon.patch
# Fix test .should.be.a.('number') isn't valid.
# https://github.com/visionmedia/batch/commit/d4c9ef6f157a765c0bc5e63486be44f9cd95c67e
Patch1:     %{name}-0.5.0-Fix-test-should.be.a-number.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
BuildRequires:  npm(should)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package
%patch0 -p1
%patch1 -p1


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/batch
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/batch

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha --require should
%endif


%files
%doc History.md Readme.md examples/
%{nodejs_sitelib}/batch


%changelog
