Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0

%global barename bluebird

Name:               nodejs-bluebird
Version:            3.5.4
Release:            alt1_3
Summary:            Full featured Promises/A+ implementation

License:            MIT
URL:                https://www.npmjs.org/package/bluebird
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel



%if 0%{?enable_tests}
BuildRequires:  npm(acorn)
BuildRequires:  npm(acorn-walk)
BuildRequires:  npm(baconjs)
BuildRequires:  npm(bluebird)
BuildRequires:  npm(body-parser)
BuildRequires:  npm(browserify)
BuildRequires:  npm(cli-table)
BuildRequires:  npm(co)
BuildRequires:  npm(cross-spawn)
BuildRequires:  npm(glob)
BuildRequires:  npm(grunt-saucelabs)
BuildRequires:  npm(highland)
BuildRequires:  npm(istanbul)
BuildRequires:  npm(jshint)
BuildRequires:  npm(jshint-stylish)
BuildRequires:  npm(kefir)
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(mocha)
BuildRequires:  npm(open)
BuildRequires:  npm(optimist)
BuildRequires:  npm(rimraf)
BuildRequires:  npm(rx)
BuildRequires:  npm(serve-static)
BuildRequires:  npm(sinon)
BuildRequires:  npm(uglify-js)
%endif
Source44: import.info


%description
Bluebird is a fully featured promise library with focus on innovative features
and performance

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build

%install
find package.json js/ -type f \
    -exec install -m0644 -D '{}' '%{buildroot}%{nodejs_sitelib}/bluebird/{}' \;

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
grunt test
%endif


%files
%doc LICENSE README.md
%dir %{nodejs_sitelib}/bluebird
%{nodejs_sitelib}/bluebird/

%changelog
