Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-buffer-crc32
Version:    0.2.1
Release:    alt1_17
Summary:    A pure JavaScript CRC32 algorithm that plays nice with binary data
License:    MIT
URL:        https://github.com/brianloveswords/buffer-crc32
Source0:    http://registry.npmjs.org/buffer-crc32/-/buffer-crc32-%{version}.tgz
# License is now in upstream repository:
# https://github.com/brianloveswords/buffer-crc32/commit/1b7489d304
Source20:   LICENSE

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(tap)
%endif
Source44: import.info

%description
This Node.js module provides a pure JavaScript CRC32 algorithm that works
with binary data and fancy character sets, output buffers, signed or unsigned
data and also has tests.

It is derived from the sample CRC implementation in the PNG specification:
http://www.w3.org/TR/PNG/#D-CRCAppendix


%prep
%setup -q -n package
cp -p %{SOURCE20} .


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/buffer-crc32
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/buffer-crc32

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%tap tests/*.test.js
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/buffer-crc32


%changelog
