Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


#use a github tarball so we get the tests
%global commit 8d3927995821596148e77f4af049ab38b03d1b99
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           nodejs-callsite
Version:        1.0.0
Release:        alt1_15
Summary:        Provides access to V8's "raw" CallSites from Node.js

#No license file included, "MIT" indicated in README and package.json
#A copy of the MIT license based on the version included with express, another
#node module by the same author, is included in Source1, and has been sent
#upstream: https://github.com/visionmedia/callsite/pull/2
License:        MIT
URL:            https://github.com/visionmedia/callsite
Source0:        https://github.com/visionmedia/callsite/archive/%{commit}/%{name}-%{version}-%{shortcommit}.tar.gz
Source1:        https://raw.github.com/tchollingsworth/callsite/8d7615a28a6507c3ef0731f072d3f1a100b3fe27/LICENSE

BuildArch:      noarch

# Fix the tests to comply with modern "should" syntax and with changes
# to the callsite code itself
Patch1:         %{name}_fix-tests.patch

BuildRequires:  node-devel rpm-build-nodejs

#for tests
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
Source44: import.info

%description
%{summary}.

This is useful for custom traces, C-style assertions, getting the line number in
execution, and more.


%prep
%setup -q -n callsite-%{commit}

#fix tests
%patch1 -p1

#copy LICENSE file into %%_builddir so it works with %%doc
cp %{SOURCE1} LICENSE


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/callsite
cp -pr index.js package.json %{buildroot}%{nodejs_sitelib}/callsite
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
mocha --require should


%files
%doc Readme.md examples History.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/callsite


%changelog
