Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-chai
Version:        3.5.0
Release:        alt1_11
Summary:        BDD/TDD assertion library for Node.js and the browser

License:        MIT
URL:            http://chaijs.com
Source0:        https://github.com/chaijs/chai/archive/%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(mocha)
BuildRequires:  npm(assertion-error)
BuildRequires:  npm(deep-eql)

Patch0001: fix-tests-on-nodejs65.patch
Source44: import.info

%description
Chai is a BDD / TDD assertion library for node and the browser that
can be delightfully paired with any JavaScript testing framework.


%prep
%setup -q -n chai-%{version}
%patch0001 -p1
%nodejs_fixdep type-detect "^2.0.0"
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/chai
cp -r package.json index.js chai.js lib %{buildroot}/%{nodejs_sitelib}/chai
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --require ./test/bootstrap --reporter dot --ui tdd test/*.js


%files
%doc README.md CONTRIBUTING.md CODE_OF_CONDUCT.md History.md ReleaseNotes.md
%{nodejs_sitelib}/chai


%changelog
