Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# tests disabled because the ansi styling fails in mock
%global enable_tests 0

Name:       nodejs-chalk
Version:    1.1.3
Release:    alt1_7
Summary:    Terminal string styling done right
License:    MIT
URL:        https://github.com/sindresorhus/chalk
Source0:    http://registry.npmjs.org/chalk/-/chalk-%{version}.tgz
Source1:    https://raw.githubusercontent.com/chalk/chalk/v%{version}/test.js
Source2:    https://raw.githubusercontent.com/chalk/chalk/v%{version}/license

# Fix tests
Patch0:     chalk-fix-lack-of-dim.patch
# Disable failing tests
Patch1:     chalk-fix-tests.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(ansi-styles)
BuildRequires:  npm(escape-string-regexp)
BuildRequires:  npm(has-ansi) >= 2.0.0
BuildRequires:  npm(has-color)
BuildRequires:  npm(strip-ansi)
BuildRequires:  npm(supports-color)

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(require-uncached)
BuildRequires:  npm(semver)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .
%patch0 -p1
%patch1 -p1

%nodejs_fixdep has-color
%nodejs_fixdep ansi-styles '^2.0.0'
%nodejs_fixdep strip-ansi
%nodejs_fixdep supports-color


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/chalk
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/chalk

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
ln -s %{nodejs_sitelib}/tape node_modules/tape
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/chalk


%changelog
