Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-character-parser
Version:    1.2.0
Release:    alt1_11
Summary:    Parse JavaScript one character at a time to look for snippets in templates
License:    MIT
URL:        https://github.com/ForbesLindesay/character-parser
Source0:    http://registry.npmjs.org/character-parser/-/character-parser-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
BuildRequires:  npm(better-assert)
%endif
Source44: import.info

%description
Parse JavaScript one character at a time to look for snippets in templates.
This is not a validator, it's just designed to allow you to have sections
of JavaScript delimited by brackets robustly.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
# Fix wrong-file-end-of-line-encoding.
for i in LICENSE README.md; do
    sed -i -e 's/\r$//' "${i}"
done

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/character-parser
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/character-parser

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha -R spec
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/character-parser


%changelog
