Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npmname chardet

Name:           nodejs-%{npmname}
Version:        0.8.0
Release:        alt1_2
Summary:        Character detection tool for NodeJS

License:        MIT
URL:            https://www.npmjs.com/package/%{npmname}

# No tests on NPM. :(
Source0:        https://github.com/runk/node-chardet/archive/v%{version}/%{npmname}-%{version}.tar.gz

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  mocha node-mocha

BuildArch:      noarch
Source44: import.info

%description
Chardet is a character detection module for NodeJS written in pure Javascript.
Module is based on ICU project http://site.icu-project.org/, which uses
character occurency analysis to determine the most probable encoding.

%prep
%setup -q -n node-chardet-%{version}


%build
# Nothing to build, this is a noarch package

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npmname}
cp -a index.js %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a match.js %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a encoding %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a package.json %{buildroot}%{nodejs_sitelib}/%{npmname}/

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
mocha -R spec --recursive --bail

%files
%{nodejs_sitelib}/%{npmname}/
%doc README.md
%doc --no-dereference LICENSE

%changelog
