Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npmname check-env

Name:           nodejs-%{npmname}
Version:        1.3.0
Release:        alt1_4
Summary:        Makes sure that all required environment variables are set

License:        MIT
URL:            https://www.npmjs.com/package/%{npmname}

Source0:        https://registry.npmjs.org/%{npmname}/-/%{npmname}-%{version}.tgz

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  dos2unix

BuildRequires:  mocha node-mocha

BuildArch:      noarch
Source44: import.info

%description
Makes sure that all required environment variables are set.

%prep
%setup -q -n package


# Remove the cowsay dependency.
%nodejs_fixdep -r cowsay

# dos2unix the README.
dos2unix README.md

%build
# Nothing to build, this is a noarch package

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npmname}
# Don't package bin.js. I think we can get away with this.
# (This is the script that includes the 'cowsay' module).
# If we want to package that script, bin.js should be patched to not use
# node-cowsay.
cp -a index.js %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a package.json %{buildroot}%{nodejs_sitelib}/%{npmname}/

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
mocha

%files
%{nodejs_sitelib}/%{npmname}/
%doc README.md
%doc --no-dereference LICENSE

%changelog
