Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename clear-require

# tests require npm(ava), which is not yet in Fedora
%global enable_tests 0

Name:		nodejs-clear-require
Version:	2.0.0
Release:	alt1_6
Summary:	Clear a module from the require cache

License:	MIT
URL:		https://github.com/sindresorhus/clear-require.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/clear-module/v%{version}/test.js
Source2:	https://raw.githubusercontent.com/sindresorhus/clear-module/v%{version}/fixture.js
Source3:	https://raw.githubusercontent.com/sindresorhus/clear-module/v%{version}/fixture-match.js


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(caller-path)
BuildRequires:	npm(resolve-from)

%if 0%{?enable_tests}
BuildRequires:	npm(ava)
%endif
Source44: import.info

%description
Clear a module from the require cache


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} %{SOURCE2} %{SOURCE3} .

%nodejs_fixdep resolve-from '^4.0.0'

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/ava
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc readme.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}

%changelog
