Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename cliui
%global enable_tests 1

Name:		nodejs-cliui
Version:	3.2.0
Release:	alt1_8
Summary:	Easily create complex multi-column command-line-interfaces

License:	ISC
URL:		https://github.com/bcoe/cliui.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# Patch to remove test that passes locally, but fails in mock/koji
# It seems that mock doesn't like ANSI codes for setting colors
Patch0:		nodejs-cliui_remove-failing-test.patch


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(chalk)
BuildRequires:	npm(string-width)
BuildRequires:	npm(wrap-ansi)
%endif
Source44: import.info

%description
Easily create complex multi-column command-line-interfaces


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
# Patch the tests
%patch0 -p1



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}



%changelog
