Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-commander
Version:    2.9.0
Release:    alt1_10
Summary:    Node.js command-line interfaces made easy
# License text is included in Readme.md
License:    MIT
URL:        https://github.com/visionmedia/commander.js
Source0:    https://registry.npmjs.org/commander/-/commander-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-v%{version}.tar.bz2
Source2:    examples-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

# Dep generator bug which adds a trailing dot in the nodejs(engine) requires.
Patch0:     %{name}-2.9.0-Fix-engine-dep.patch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(should)
BuildRequires:  npm(sinon)
BuildRequires:  npm(graceful-readlink)
%endif
Source44: import.info

%description
The complete solution for Node.js command-line interfaces,
inspired by Ruby's commander.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package
%patch0 -p1


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/commander
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/commander

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
./test/run test/test.*.js
%endif


%files
%doc Readme.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/commander


%changelog
