Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename commonmark
%global enable_tests 1

Name:		nodejs-commonmark
Version:	0.24.0
Release:	alt1_7
Summary:	A strongly specified, highly compatible variant of Markdown

License:	BSD and MIT and Creative Commons
# Most of the files in this packages are BSD licensed.  The exceptions are:
#
# lib/normalize-reference.js is a slightly modified version of
# https://github.com/dmoscrop/fold-case and licensed under the MIT license
#
# lib/from-code-point.js is derived from a polyfill
# Copyright Mathias Bynens <http://mathiasbynens.be/>, and is licensed under
# the MIT license
#
# With the exception of `bench/samples/README.md`, the samples in
# `bench/samples` are taken from https://github.com/markdown-it/markdown-it
# and licensed under the MIT license
#
# The CommonMark spec (spec.txt) in test/ is Copyright (C) 2014-15 John 
# MacFarlane and licensed under the Creative Commons CC-BY-SA 4.0 license
#
# More details, including the license text, is in the LICENSE file

URL:		https://github.com/jgm/commonmark.js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1,2} is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source2:	tools-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(entities)
BuildRequires:	npm(mdurl)
BuildRequires:	npm(string.prototype.repeat)
%endif

Requires:	node
Source44: import.info

%description
A strongly specified, highly compatible variant of Markdown


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
# setup the tools
%setup -q -T -D -a 2 -n package

# remove executable permission from lib/index.js
chmod -x ./lib/index.js



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ tools/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/commonmark %{buildroot}%{nodejs_sitelib}/%{packagename}/bin/commonmark

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/commonmark \
    %{buildroot}%{_bindir}/commonmark



%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%{__nodejs} ./test/test.js
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}
%{_bindir}/commonmark



%changelog
