Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-concat-stream
Version:        1.6.0
Release:        alt1_11
Summary:        Writable stream that concatenates data and calls a callback with the result
License:        MIT
URL:            https://github.com/maxogden/concat-stream
Source0:        https://github.com/maxogden/concat-stream/archive/v%{version}/concat-stream-%{version}.tar.gz
# https://github.com/maxogden/concat-stream/pull/43
Patch0:         nodejs-concat-stream-typedarray.patch
# Fix engines specification in package.json
Patch1:         nodejs-concat-stream-engines.patch
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(tape)
BuildRequires:  npm(inherits)
BuildRequires:  npm(readable-stream)
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n concat-stream-%{version}
%patch0 -p1
%patch1 -p1


%nodejs_fixdep readable-stream '^2.0.5'
%nodejs_fixdep -r typedarray


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/concat-stream
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/concat-stream

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/tape test/*.js test/server/*.js
%endif


%files
%doc readme.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/concat-stream


%changelog
