Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-constantinople
Version:    2.0.0
Release:    alt1_13
Summary:    Determine whether a JavaScript expression evaluates to a constant
License:    MIT
URL:        https://github.com/ForbesLindesay/constantinople
Source0:    http://registry.npmjs.org/constantinople/-/constantinople-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  mocha
BuildRequires:  uglify-js
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
find . -type f -exec chmod -x '{}' \;
for i in LICENSE README.md; do
    sed -i -e 's/\r$//' "${i}"
done

%nodejs_fixdep uglify-js '^2.2'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/constantinople
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/constantinople

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
if [ ! -d node_modules/uglify-js ]; then
    ln -sf /usr/lib/node_modules/uglify-js node_modules/uglify-js
fi
/usr/bin/mocha -R spec
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/constantinople


%changelog
