Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename conventional-changelog-preset-loader
%global enable_tests 1

Name:		nodejs-%{packagename}
Version:	1.1.8
Release:	alt1_5
Summary:	Configuration preset loader for conventional-changelog

License:	MIT
URL:		https://github.com/conventional-changelog/conventional-changelog/tree/master/packages/conventional-changelog-preset-loader
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	%{packagename}-tests-%{version}.tar.bz2
Source10:	dl-cc-tests.sh


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(sinon)
BuildRequires:	npm(sinon-chai)
%endif
Source44: import.info

%description
Configuration preset loader for conventional-changelog.


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package


%if 0%{?enable_tests}
%nodejs_fixdep chai
%nodejs_fixdep mocha
%endif

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}

%changelog
