Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename conventional-commits-filter
%global enable_tests 1

Name:		nodejs-conventional-commits-filter
Version:	1.1.6
Release:	alt1_5
Summary:	Filter out reverted commits parsed by conventional-commits-parser

License:	MIT
URL:		https://github.com/stevemao/conventional-commits-filter
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	 https://raw.githubusercontent.com/conventional-changelog/conventional-changelog/%{packagename}%%40%{version}/packages/%{packagename}/test.js


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(is-subset)
BuildRequires:	npm(modify-values)
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Filter out reverted commits parsed by conventional-commits-parser


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .

%nodejs_fixdep mocha

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha --timeout 30000
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
